/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_imultiviewnotificationslistener_proxy.h"

#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv::binding::java;

ttv::binding::java::JavaIMultiviewNotificationsListenerProxy::JavaIMultiviewNotificationsListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IMultiviewNotificationsListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaIMultiviewNotificationsListenerProxy::ChanletUpdated(
  UserId userId, ChannelId channelId, Chanlet&& chanlet) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jChanlet, GetJavaInstance_Chanlet(gActiveJavaEnvironment, std::move(chanlet)));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["chanletUpdated"], static_cast<jint>(userId),
    static_cast<jint>(channelId), jChanlet);
}
