/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_isquadnotificationslistener_proxy.h"

#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv::binding::java;

ttv::binding::java::JavaISquadNotificationsListenerProxy::JavaISquadNotificationsListenerProxy() {
  mListenerInfo = GetJavaClassInfo_ISquadNotificationsListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaISquadNotificationsListenerProxy::SquadUpdated(SquadInfo&& squad) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jSquadInfo, GetJavaInstance_SquadInfo(gActiveJavaEnvironment, squad));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["squadUpdated"], jSquadInfo);
}

void ttv::binding::java::JavaISquadNotificationsListenerProxy::SquadEnded() {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["squadEnded"]);
}
