/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_isubscriptionsnotificationslistener_proxy.h"

#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv::binding::java;

ttv::binding::java::JavaISubscriptionsNotificationsListenerProxy::JavaISubscriptionsNotificationsListenerProxy() {
  mListenerInfo = GetJavaClassInfo_ISubscriptionsNotificationsListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaISubscriptionsNotificationsListenerProxy::SubscribedToChannel(
  UserId userId, ChannelId channelId) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["subscribedToChannel"], static_cast<jint>(userId), static_cast<jint>(channelId));
}
