/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_subscriberslistenerproxy.h"

#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv;
using namespace ttv::chat;

ttv::binding::java::JavaSubscribersListenerProxy::JavaSubscribersListenerProxy() {
  mListenerInfo = GetJavaClassInfo_ISubscribersListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaSubscribersListenerProxy::NewSubscriberAdded(
  const SubscriberAddedEvent& subscriberAddedEvent) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jSubscriberAddedEvent,
    GetJavaInstance_ChatSubscriberAddedEvent(gActiveJavaEnvironment, subscriberAddedEvent));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["newSubscriberAdded"], jSubscriberAddedEvent);
}
