/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/generated/jni_chatchannelproxy.h"

#include "twitchsdk/chat/ichatchannel.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv;
using namespace ttv::chat;
using namespace ttv::binding::java;

#define GET_NATIVE_PTR(x) reinterpret_cast<IChatChannel*>(x)

JNIEXPORT jobject JNICALL Java_tv_twitch_chat_ChatChannelProxy_Connect(
  JNIEnv* jEnv, jobject /*jThis*/, jlong jNativeObjectPointer) {
  auto channel = GET_NATIVE_PTR(jNativeObjectPointer);

  return GetJavaInstance_ErrorCode(jEnv, channel->Connect());
}

JNIEXPORT jobject JNICALL Java_tv_twitch_chat_ChatChannelProxy_Disconnect(
  JNIEnv* jEnv, jobject /*jThis*/, jlong jNativeObjectPointer) {
  auto channel = GET_NATIVE_PTR(jNativeObjectPointer);

  return GetJavaInstance_ErrorCode(jEnv, channel->Disconnect());
}

JNIEXPORT jobject JNICALL Java_tv_twitch_chat_ChatChannelProxy_SendMessage(
  JNIEnv* jEnv, jobject /*jThis*/, jlong jNativeObjectPointer, jstring jMessage) {
  auto channel = GET_NATIVE_PTR(jNativeObjectPointer);

  ScopedJavaUTFStringConverter converter(jEnv, jMessage);
  return GetJavaInstance_ErrorCode(jEnv, channel->SendMessage(converter.GetNativeString()));
}

JNIEXPORT void JNICALL Java_tv_twitch_chat_ChatChannelProxy_DisposeNativeInstance(
  JNIEnv* jEnv, jobject jThis, jlong jNativeObjectPointer) {
  auto context = gIChatChannelRegistry.LookupNativeContext(jThis);
  if (context == nullptr) {
    return;
  }

  auto instance = gIChatChannelRegistry.LookupNativeInstance(jThis);
  if (instance == nullptr) {
    return;
  }

  instance->Dispose();
  gIChatChannelRegistry.Unregister(jThis);
}
