/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/generated/jni_chatroomnotificationsproxy.h"

#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/internal/chatroomnotifications.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv;
using namespace ttv::chat;
using namespace ttv::binding::java;

#define GET_NATIVE_PTR(x) reinterpret_cast<IChatRoomNotifications*>(x)

JNIEXPORT void JNICALL Java_tv_twitch_chat_ChatRoomNotificationsProxy_DisposeNativeInstance(
  JNIEnv* jEnv, jobject jThis, jlong jNativeObjectPointer) {
  auto instance = gIChatRoomNotificationsInstanceRegistry.LookupNativeInstance(jThis);
  if (instance == nullptr) {
    return;
  }

  TTV_ErrorCode ec = instance->Dispose();

  if (TTV_SUCCEEDED(ec)) {
    gIChatRoomNotificationsInstanceRegistry.Unregister(jThis);
  }
}
