package tv.twitch.test;

import java.util.*;
import tv.twitch.*;
import tv.twitch.chat.*;
import tv.twitch.chat.ChatRoomMessageHandler.CommandError;

public class ChatTest extends TestBase {
    protected CoreAPI m_CoreApi = null;
    protected boolean m_CoreApiInitialized = false;

    protected class CoreApiState { public boolean initialized = false; }

    protected class ChatApiState { public boolean initialized = false; }

    protected ICoreAPIListener m_CoreApiListener = new ICoreAPIListener() {
        @Override
        public void moduleStateChanged(IModule source, ModuleState state, ErrorCode result) {
            m_CoreApiInitialized = state == ModuleState.Initialized || state == ModuleState.ShuttingDown;
        }

        @Override
        public void coreUserLoginComplete(String oauthToken, int userId, ErrorCode ec) {}

        @Override
        public void coreUserLogoutComplete(int userId, ErrorCode ec) {}

        @Override
        public void coreUserAuthenticationIssue(int userId, String oauthToken, ErrorCode ec) {}

        @Override
        public void corePubSubStateChanged(int userId, CorePubSubState state, ErrorCode result) {}
    };

    protected IChatChannelListener mChatChannelListener = new IChatChannelListener() {
        @Override
        public void chatChannelStateChanged(int userId, int channelId, ChatChannelState state, ErrorCode ec) {}

        @Override
        public void chatChannelInfoChanged(int userId, int channelId, ChatChannelInfo channelInfo) {}

        @Override
        public void chatChannelRestrictionsChanged(int userId, int channelId, ChatChannelRestrictions restrictions) {}

        @Override
        public void chatChannelLocalUserChanged(int userId, int channelId, ChatUserInfo userInfo) {}

        @Override
        public void chatChannelMessagesReceived(int userId, int channelId, ChatLiveMessage[] messageList) {}

        @Override
        public void chatChannelSubscriptionNoticeReceived(int userId, int channelId, ChatSubscriptionNotice notice) {}

        @Override
        public void chatChannelFirstTimeChatterNoticeReceived(
            int userId, int channelId, ChatFirstTimeChatterNotice notice) {}

        @Override
        public void chatChannelRaidNoticeReceived(int userId, int channelId, ChatRaidNotice notice) {}

        @Override
        public void chatChannelUnraidNoticeReceived(int userId, int channelId, ChatUnraidNotice notice) {}

        @Override
        public void chatChannelGenericNoticeReceived(int userId, int channelId, ChatGenericMessageNotice notice) {}

        @Override
        public void chatChannelMessagesCleared(int userId, int channelId) {}

        @Override
        public void chatChannelUserMessagesCleared(int userId, int channelId, int clearUserId) {}

        @Override
        public void chatChannelHostTargetChanged(int userId, int channelId, String targetChannelName, int numViewers) {}

        @Override
        public void chatChannelNoticeReceived(
            int userId, int channelId, String noiceId, HashMap<String, String> params) {}

        @Override
        public void autoModCaughtSentMessage(int userId, int channelId) {}

        @Override
        public void autoModDeniedSentMessage(int userId, int channelId) {}

        @Override
        public void autoModApprovedSentMessage(int userId, int channelId) {}

        @Override
        public void autoModCaughtMessageForMods(int userId, int channelId, String messageId, String message,
            int senderId, String senderName, String reason) {}

        @Override
        public void autoModMessageApprovedByMod(
            int userId, int channelId, String messageId, int moderatorId, String moderatorName) {}

        @Override
        public void autoModMessageDeniedByMod(
            int userId, int channelId, String messageId, int moderatorId, String moderatorName) {}

        @Override
        public void autoModDeniedSentCheer(int userId, int channelId) {}

        @Override
        public void autoModTimedOutSentCheer(int userId, int channelId) {}

        @Override
        public void autoModCaughtCheerForMods(int userId, int channelId, String messageId, String message, int senderId,
            String senderName, String reason) {}

        @Override
        public void chatChannelModNoticeMessageDeleted(
            int userId, int channelId, ModerationActionInfo modActionInfo, String messageId, String message) {}

        @Override
        public void chatChannelModNoticeUserTimedOut(
            int userId, int channelId, ModerationActionInfo modActionInfo, int timeoutDurationSeconds, String reason) {}

        @Override
        public void chatChannelModNoticeUserBanned(
            int userId, int channelId, ModerationActionInfo modActionInfo, String reason) {}

        @Override
        public void chatChannelModNoticeUserUntimedOut(int userId, int channelId, ModerationActionInfo modActionInfo) {}

        @Override
        public void chatChannelModNoticeUserUnbanned(int userId, int channelId, ModerationActionInfo modActionInfo) {}

        @Override
        public void chatChannelModNoticeClearChat(int userId, int channelId, int modId, String modName) {}

        @Override
        public void chatChannelModNoticeEmoteOnly(int userId, int channelId, int modId, String modName) {}

        @Override
        public void chatChannelModNoticeEmoteOnlyOff(int userId, int channelId, int modId, String modName) {}

        @Override
        public void chatChannelModNoticeFollowersOnly(
            int userId, int channelId, int modId, String modName, int minimumFollowingDuration) {}

        @Override
        public void chatChannelModNoticeFollowersOnlyOff(int userId, int channelId, int modId, String modName) {}

        @Override
        public void chatChannelModNoticeR9K(int userId, int channelId, int modId, String modName) {}

        @Override
        public void chatChannelModNoticeR9KOff(int userId, int channelId, int modId, String modName) {}

        @Override
        public void chatChannelModNoticeSlow(
            int userId, int channelId, int modId, String modName, int slowModeDurationSeconds) {}

        @Override
        public void chatChannelModNoticeSlowOff(int userId, int channelId, int modId, String modName) {}

        @Override
        public void chatChannelModNoticeSubsOnly(int userId, int channelId, int modId, String modName) {}

        @Override
        public void chatChannelModNoticeSubsOnlyOff(int userId, int channelId, int modId, String modName) {}

        @Override
        public void chatChannelMessageDeleted(
            int userId, int channelId, String messageId, String senderLoginName, String deletedMessageComment) {}
    };

    // These are native functions (called in c++) that will call of the functions in
    // the listeners for test purposes.
    private native void Test_IChatAPIListener(IModule module, IChatAPIListener listener);

    private native void Test_IChatChannelListener(IModule module, IChatChannelListener listener);

    private native void Test_IChatUserThreadsListener(IModule module, IChatUserThreadsListener listener);

    private native void Test_IChatRaidListener(IModule module, IChatRaidListener listener);

    private native void Test_IBitsListener(IModule module, IBitsListener listener);

    private native void Test_IFollowersListener(IModule module, IFollowersListener listener);

    private native void Test_IFollowingListener(IModule module, IFollowingListener listener);

    private native void Test_ISubscribersListener(IModule module, ISubscribersListener listener);

    private native void Test_IChatRoomNotificationsListener(IModule module, IChatRoomNotificationsListener listener);

    private native void Test_IChatRoomListener(IModule module, IChatRoomListener listener);

    private native void Test_IChatChannelPropertyListener(IModule module, IChatChannelPropertyListener listener);

    private native void Test_IChatCommentListener(IModule module, IChatCommentListener listener);

    private native void Test_ISubscriptionsNotificationsListener(
        IModule module, ISubscriptionsNotificationsListener listener);

    private native void Test_ISquadNotificationsListener(IModule module, ISquadNotificationsListener listener);

    private native void Test_IMultiviewNotificationsListener(IModule module, IMultiviewNotificationsListener listener);

    private native ChatWhisperMessage Test_JniChatWhisperMessage();

    public ChatTest(Library library) {
        super(library);

        ChatErrorCode.forceClassInit();
    }

    @Override
    public void run() throws Exception {
        System.out.println("Running ChatTest tests...");

        // Uncomment these if you want to test

        // Interfaces
        // test_IChatAPIListener();
        // test_IChatChannelListener();
        // test_IChatUserThreadsListener();
        // test_IChatRaidListener();
        // test_IBitsListener();
        // test_IFollowersListener();
        // test_IFollowingListener();
        // test_ISubscribersListener();
        // test_IChatRoomNotificationsListener();
        // test_IChatRoomListener();
        // test_IChatChannelPropertyListener();
        // test_IChatCommentListener();
        // test_ISubscriptionsNotificationsListener();
        // test_ISquadNotificationsListener();
        // test_IMultiviewNotificationsListener();

        // ChatAPI
        // test_ChatMessageHandler();
        // test_ChatRoomMessageHandler();
        // test_ChatRaid();
        // test_FetchBlockedUsers();
        // test_MessageInfo();
        // test_FetchBadges();
        // test_BitsStatus();
        // test_FollowersStatus();
        // test_FollowingStatus();
        // test_SubscribersStatus();
        // test_BanUser();
        // test_UnbanUser();
        // test_ModUser();
        // test_UnmodUser();
        // test_UpdateUserColor();
        // test_FetchChannelModerators();
        // test_ChatRooms();
        // test_ChatChannelProperties();
        // test_CreateChatChannel();
        // test_ChatCommentManager();
        // test_SubscriptionsNotifications();
        // test_VIP();
        // test_SquadNotifications();
        // test_MultiviewNotifications();

        // test_JniChatWhisperMessage();

        System.out.println("Done running ChatTest tests...");
    }

    protected ErrorCode setup(final ResultContainer<CoreAPI> coreApi, final ResultContainer<ChatAPI> chatApi)
        throws InterruptedException {
        final CoreApiState coreApiState = new CoreApiState();
        final ChatApiState chatApiState = new ChatApiState();

        // m_Library.setGlobalMessageLevel(MessageLevel.TTV_ML_ERROR);

        ErrorCode ec = CoreErrorCode.TTV_EC_SUCCESS;

        ICoreAPIListener coreApiListener = new ICoreAPIListener() {
            @Override
            public void moduleStateChanged(IModule source, ModuleState state, ErrorCode result) {
                coreApiState.initialized = state == ModuleState.Initialized || state == ModuleState.ShuttingDown;
            }

            @Override
            public void coreUserLoginComplete(String oauthToken, int userId, ErrorCode ec) {}

            @Override
            public void coreUserLogoutComplete(int userId, ErrorCode ec) {}

            @Override
            public void coreUserAuthenticationIssue(int userId, String oauthToken, ErrorCode ec) {}

            @Override
            public void corePubSubStateChanged(int userId, CorePubSubState state, ErrorCode result) {}
        };

        IChatAPIListener chatApiListener = new IChatAPIListener() {
            @Override
            public void moduleStateChanged(IModule source, ModuleState state, ErrorCode result) {
                chatApiState.initialized = state == ModuleState.Initialized || state == ModuleState.ShuttingDown;
            }

            @Override
            public void chatUserEmoticonSetsChanged(int userId, ChatEmoticonSet[] emoticonSets) {}
        };

        coreApi.result = new CoreAPI();
        coreApi.result.setListener(coreApiListener);
        initializeModule(coreApi.result);
        addModule(coreApi.result);

        chatApi.result = new ChatAPI();
        chatApi.result.setCoreApi(coreApi.result);
        chatApi.result.setListener(chatApiListener);

        ChatTokenizationOptions flags = new ChatTokenizationOptions();
        flags.emoticons = true;
        flags.mentions = true;
        flags.urls = true;
        flags.bits = true;
        chatApi.result.setTokenizationOptions(flags);
        initializeModule(chatApi.result);
        addModule(chatApi.result);

        // Log in a user
        if (m_OauthToken != null) {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;

            ec = coreApi.result.logIn(m_OauthToken, new CoreAPI.LogInCallback() {
                @Override
                public void invoke(ErrorCode ec, UserInfo userInfo) {
                    callbackCalled.result = true;
                    if (ec.succeeded()) {
                        System.out.println("Logged in successfully");
                    }
                }
            });

            if (ec.succeeded()) {
                while (!callbackCalled.result) {
                    Thread.sleep(100);
                    updateModules();
                }
            }
        }

        return ec;
    }

    protected void test_IChatAPIListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IChatAPIListener chatApiListener = new IChatAPIListener() {
            @Override
            public void moduleStateChanged(IModule source, ModuleState state, ErrorCode result) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatUserEmoticonSetsChanged(int userId, ChatEmoticonSet[] emoticonSets) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IChatAPIListener(mDummyModule, chatApiListener);

        // Make sure they were all called
        checkAllMethodsCalled(IChatAPIListener.class, calls);
    }

    protected void test_IChatChannelListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IChatChannelListener chatChannelListener = new IChatChannelListener() {
            @Override
            public void chatChannelStateChanged(int userId, int channelId, ChatChannelState state, ErrorCode ec) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelInfoChanged(int userId, int channelId, ChatChannelInfo channelInfo) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelRestrictionsChanged(
                int userId, int channelId, ChatChannelRestrictions restrictions) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelLocalUserChanged(int userId, int channelId, ChatUserInfo userInfo) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelMessagesReceived(int userId, int channelId, ChatLiveMessage[] messageList) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelSubscriptionNoticeReceived(
                int userId, int channelId, ChatSubscriptionNotice notice) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelFirstTimeChatterNoticeReceived(
                int userId, int channelId, ChatFirstTimeChatterNotice notice) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelRaidNoticeReceived(int userId, int channelId, ChatRaidNotice notice) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelUnraidNoticeReceived(int userId, int channelId, ChatUnraidNotice notice) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelGenericNoticeReceived(int userId, int channelId, ChatGenericMessageNotice notice) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelMessagesCleared(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelUserMessagesCleared(int userId, int channelId, int clearUserId) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelHostTargetChanged(
                int userId, int channelId, String targetChannelName, int numViewers) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelNoticeReceived(
                int userId, int channelId, String noticeId, HashMap<String, String> params) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void autoModCaughtSentMessage(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void autoModDeniedSentMessage(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void autoModApprovedSentMessage(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void autoModCaughtMessageForMods(int userId, int channelId, String messageId, String message,
                int senderId, String senderName, String reason) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void autoModMessageApprovedByMod(
                int userId, int channelId, String messageId, int moderatorId, String moderatorName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void autoModMessageDeniedByMod(
                int userId, int channelId, String messageId, int moderatorId, String moderatorName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeMessageDeleted(
                int userId, int channelId, ModerationActionInfo modActionInfo, String messageId, String message) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void autoModDeniedSentCheer(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void autoModTimedOutSentCheer(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void autoModCaughtCheerForMods(int userId, int channelId, String messageId, String message,
                int senderId, String senderName, String reason) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeUserTimedOut(int userId, int channelId, ModerationActionInfo modActionInfo,
                int timeoutDurationSeconds, String reason) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeUserBanned(
                int userId, int channelId, ModerationActionInfo modActionInfo, String reason) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeUserUntimedOut(
                int userId, int channelId, ModerationActionInfo modActionInfo) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeUserUnbanned(
                int userId, int channelId, ModerationActionInfo modActionInfo) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeClearChat(int userId, int channelId, int modId, String modName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeEmoteOnly(int userId, int channelId, int modId, String modName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeEmoteOnlyOff(int userId, int channelId, int modId, String modName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeFollowersOnly(
                int userId, int channelId, int modId, String modName, int minimumFollowingDuration) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeFollowersOnlyOff(int userId, int channelId, int modId, String modName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeR9K(int userId, int channelId, int modId, String modName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeR9KOff(int userId, int channelId, int modId, String modName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeSlow(
                int userId, int channelId, int modId, String modName, int slowModeDurationSeconds) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeSlowOff(int userId, int channelId, int modId, String modName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeSubsOnly(int userId, int channelId, int modId, String modName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelModNoticeSubsOnlyOff(int userId, int channelId, int modId, String modName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelMessageDeleted(
                int userId, int channelId, String messageId, String senderLoginName, String deletedMessageContent) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IChatChannelListener(mDummyModule, chatChannelListener);

        // Make sure they were all called
        checkAllMethodsCalled(IChatChannelListener.class, calls);
    }

    protected void test_IChatUserThreadsListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IChatUserThreadsListener chatUserThreadsListener = new IChatUserThreadsListener() {
            @Override
            public void chatThreadRealtimeMessageReceived(int userId, String threadId, ChatWhisperMessage message) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IChatUserThreadsListener(mDummyModule, chatUserThreadsListener);

        // Make sure they were all called
        checkAllMethodsCalled(IChatUserThreadsListener.class, calls);
    }

    protected void test_IChatRaidListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IChatRaidListener chatRaidListener = new IChatRaidListener() {
            @Override
            public void raidStarted(ChatRaidStatus status) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void raidUpdated(ChatRaidStatus status) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void raidFired(ChatRaidStatus status) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void raidCancelled(ChatRaidStatus status) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IChatRaidListener(mDummyModule, chatRaidListener);

        // Make sure they were all called
        checkAllMethodsCalled(IChatRaidListener.class, calls);
    }

    protected void test_IBitsListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IBitsListener bitsListener = new IBitsListener() {
            @Override
            public void userReceivedBits(ChatBitsReceivedEvent bitsReceivedEvent) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void userSentBits(ChatBitsSentEvent bitsSentEvent) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void userGainedBits(int bitsBalance) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IBitsListener(mDummyModule, bitsListener);

        // Make sure they were all called
        checkAllMethodsCalled(IBitsListener.class, calls);
    }

    protected void test_IFollowersListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IFollowersListener followersListener = new IFollowersListener() {
            @Override
            public void newFollowerAdded(ChatFollowerAddedEvent followerAddedEvent) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IFollowersListener(mDummyModule, followersListener);

        // Make sure they were all called
        checkAllMethodsCalled(IFollowersListener.class, calls);
    }

    protected void test_IFollowingListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IFollowingListener followingListener = new IFollowingListener() {
            @Override
            public void followedChannel(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void unfollowedChannel(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IFollowingListener(mDummyModule, followingListener);

        // Make sure they were all called
        checkAllMethodsCalled(IFollowingListener.class, calls);
    }

    protected void test_ISubscribersListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        ISubscribersListener subscribersListener = new ISubscribersListener() {
            @Override
            public void newSubscriberAdded(ChatSubscriberAddedEvent subscriberAddedEvent) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_ISubscribersListener(mDummyModule, subscribersListener);

        // Make sure they were all called
        checkAllMethodsCalled(ISubscribersListener.class, calls);
    }

    protected void test_ChatMessageHandler() throws Exception {
        ChatMessageHandler handler = new ChatMessageHandler();
        final HashSet<String> calls = new HashSet<>();

        class testCallbacks implements ChatMessageHandler.ICallbacks {
            @Override
            public boolean passThrough(String message) {
                func = 0;
                this.message = message;
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean blockUser(String blockUserName) {
                func = 1;
                this.userName = blockUserName;
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean unblockUser(String unblockUserName) {
                func = 2;
                this.userName = unblockUserName;
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean whisperUser(String whisperUserName, String message) {
                func = 3;
                this.userName = whisperUserName;
                this.message = message;
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean createRaid(String raidTargetUserName) {
                func = 4;
                this.userName = raidTargetUserName;
                calls.add(getCurrentMethodName());
                return false;
            }

            @Override
            public boolean cancelRaid() {
                func = 5;
                calls.add(getCurrentMethodName());
                return false;
            }

            @Override
            public boolean grantVIP(String vipUserName) {
                func = 6;
                calls.add(getCurrentMethodName());
                return false;
            }

            @Override
            public boolean revokeVIP(String unvipUserName) {
                func = 7;
                calls.add(getCurrentMethodName());
                return false;
            }

            @Override
            public boolean listVIPs() {
                func = 8;
                calls.add(getCurrentMethodName());
                return false;
            }

            public int func;
            public String userName;
            public String message;
        }

        testCallbacks callbacks = new testCallbacks();

        handler.setCallbacks(callbacks);

        handler.handleMessage("this is a normal message");
        handler.handleMessage("/block Twitch");
        handler.handleMessage("/ignore Twitch other words afterwards ignored");
        handler.handleMessage("/unignore Twitch");
        handler.handleMessage("/w Twitch hello there");
        handler.handleMessage("/raid user_name");
        handler.handleMessage("/unraid");
        handler.handleMessage("/unrecognizedcommand oh no");
        handler.handleMessage("/vip user");
        handler.handleMessage("/unvip user");
        handler.handleMessage("/vips");

        checkAllMethodsCalled(testCallbacks.class, calls);
    }

    protected void test_ChatRoomMessageHandler() throws Exception {
        ChatRoomMessageHandler handler = new ChatRoomMessageHandler();
        final HashSet<String> calls = new HashSet<>();

        class testCallbacks implements ChatRoomMessageHandler.ICallbacks {
            @Override
            public boolean passThrough(String message) {
                System.out.println("Send normal message: " + message);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean banUser(String userName) {
                System.out.println("Ban user " + userName);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean timeoutUser(String userName, int duration) {
                System.out.println("Timeout user " + userName + " with duration " + duration);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean blockUser(String userName) {
                System.out.println("Block user: " + userName);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean setUserColor(String color) {
                System.out.println("Set user color " + color);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean help() {
                System.out.println("Display help");
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean listRooms() {
                System.out.println("List chat rooms for current channel");
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean modUser(String userName) {
                System.out.println("Mod user " + userName);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean listModerators() {
                System.out.println("List mods for current channel");
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean setTopic(String topic) {
                System.out.println("Set topic: " + topic);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean unbanUser(String userName) {
                System.out.println("Unban user " + userName);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean unmodUser(String userName) {
                System.out.println("Unmod user " + userName);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean untimeoutUser(String userName) {
                System.out.println("Untimeout user " + userName);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean unblockUser(String userName) {
                System.out.println("Unblock user: " + userName);
                calls.add(getCurrentMethodName());
                return true;
            }

            @Override
            public boolean slowMode(boolean turnOn, int duration) {
                calls.add(getCurrentMethodName());
                if (turnOn) {
                    System.out.println("Enable slow mode with duration " + duration + " seconds");
                } else {
                    System.out.println("Disable slow mode");
                }
                return true;
            }

            @Override
            public boolean r9kMode(boolean turnOn) {
                calls.add(getCurrentMethodName());
                if (turnOn) {
                    System.out.println("Enable r9k mode");
                } else {
                    System.out.println("Disable r9k mode");
                }
                return true;
            }

            @Override
            public boolean emotesOnlyMode(boolean turnOn) {
                calls.add(getCurrentMethodName());
                if (turnOn) {
                    System.out.println("Enable emotes-only mode");
                } else {
                    System.out.println("Disable emotes-only mode");
                }
                return true;
            }

            @Override
            public boolean malformedCommand(CommandError command, String commandText) {
                System.out.println("Error parsing message");
                calls.add(getCurrentMethodName());
                if (command == CommandError.Unknown) {
                    System.out.println("Unknown command: " + commandText);
                }
                return true;
            }
        }

        testCallbacks callbacks = new testCallbacks();

        handler.setCallbacks(callbacks);

        handler.handleMessage("this is a normal message");
        handler.handleMessage("/ban USERNAME");
        handler.handleMessage("/timeout USERNAME 500");
        handler.handleMessage("/ignore USERNAME");
        handler.handleMessage("/color #000000");
        handler.handleMessage("/help");
        handler.handleMessage("/listrooms");
        handler.handleMessage("/mod USERNAME");
        handler.handleMessage("/mods");
        handler.handleMessage("/topic this is a new topic");
        handler.handleMessage("/unban USERNAME");
        handler.handleMessage("/untimeout USERNAME");
        handler.handleMessage("/unmod USERNAME");
        handler.handleMessage("/unignore USERNAME");
        handler.handleMessage("/slow");
        handler.handleMessage("/slow 90");
        handler.handleMessage("/slowoff");
        handler.handleMessage("/r9kbeta");
        handler.handleMessage("/r9kbetaoff");
        handler.handleMessage("/emoteonly");
        handler.handleMessage("/emoteonlyoff");

        // These should call the error function
        handler.handleMessage("/topic");
        handler.handleMessage("/color");
        handler.handleMessage("/ban");
        handler.handleMessage("/slow invalid");

        // Unhandled commands are returned as an unknown malformed command
        handler.handleMessage("/notacommand");

        checkAllMethodsCalled(testCallbacks.class, calls);
    }

    protected void test_IChatRoomNotificationsListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IChatRoomNotificationsListener listener = new IChatRoomNotificationsListener() {
            @Override
            public void userTimedOut(int userId, int channelId, int expiresAt) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void userBanned(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void userUnbanned(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void roomViewUpdated(int userId, int ownerId, String roomId, ChatRoomView roomViewInfo) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void roomMentionReceived(int userId, RoomMentionInfo mentionInfo) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IChatRoomNotificationsListener(mDummyModule, listener);

        // Make sure they were all called
        checkAllMethodsCalled(IChatRoomNotificationsListener.class, calls);
    }

    protected void test_IChatRoomListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IChatRoomListener listener = new IChatRoomListener() {
            @Override
            public void messageReceived(String roomId, ChatRoomMessage message) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void messageEdited(String roomId, ChatRoomMessage message) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void messageDeleted(String roomId, ChatRoomMessage message) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void roomUpdated(ChatRoomInfo roomInfo) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IChatRoomListener(mDummyModule, listener);

        // Make sure they were all called
        checkAllMethodsCalled(IChatRoomListener.class, calls);
    }

    protected void test_IChatChannelPropertyListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IChatChannelPropertyListener listener = new IChatChannelPropertyListener() {
            @Override
            public void ritualsEnabled(boolean ritualsEnabled) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void outgoingHostChanged(
                int channelId, int previousTarget, int currentTarget, String currentTargetName, int numViewers) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void incomingHostStarted(int channelId, int hostChannelId, String hostChannelName, int numViewers) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void incomingHostEnded(int channelId, int hostChannelId, String hostChannelName) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void extensionMessageReceived(ExtensionMessage message) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatChannelRestrictionsReceived(ChatChannelRestrictions restrictions) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IChatChannelPropertyListener(mDummyModule, listener);

        // Make sure they were all called
        checkAllMethodsCalled(IChatChannelPropertyListener.class, calls);
    }

    protected void test_IChatCommentListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IChatCommentListener listener = new IChatCommentListener() {
            @Override
            public void chatCommentManagerStateChanged(int userId, String vodId, PlayingState state) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatCommentsReceived(int userId, String vodId, ChatComment[] messageList) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void chatCommentsErrorReceived(String errorMsg, int ec) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IChatCommentListener(mDummyModule, listener);

        // Make sure they were all called
        checkAllMethodsCalled(IChatCommentListener.class, calls);
    }

    protected void test_ISubscriptionsNotificationsListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        ISubscriptionsNotificationsListener listener = new ISubscriptionsNotificationsListener() {
            @Override
            public void subscribedToChannel(int userId, int channelId) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_ISubscriptionsNotificationsListener(mDummyModule, listener);

        // Make sure they were all called
        checkAllMethodsCalled(ISubscriptionsNotificationsListener.class, calls);
    }

    protected void test_ISquadNotificationsListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        ISquadNotificationsListener listener = new ISquadNotificationsListener() {
            @Override
            public void squadUpdated(SquadInfo squad) {
                calls.add(getCurrentMethodName());
            }

            @Override
            public void squadEnded() {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_ISquadNotificationsListener(mDummyModule, listener);

        // Make sure they were all called
        checkAllMethodsCalled(ISquadNotificationsListener.class, calls);
    }

    protected void test_IMultiviewNotificationsListener() throws Exception {
        final HashSet<String> calls = new HashSet<>();

        IMultiviewNotificationsListener listener = new IMultiviewNotificationsListener() {
            @Override
            public void chanletUpdated(int userId, int channelId, Chanlet chanlet) {
                calls.add(getCurrentMethodName());
            }
        };

        // Ask native to call each method on our interface
        Test_IMultiviewNotificationsListener(mDummyModule, listener);

        // Make sure they were all called
        checkAllMethodsCalled(IMultiviewNotificationsListener.class, calls);
    }

    public static long start = 0;
    public static long end = 0;
    public static long actionsStart = 0;
    public static long actionsEnd = 0;
    public static double firstDuration = 0;
    public static double firstActionsDuration = 0;
    public static double duration = 0;
    public static double actionsDuration = 0;
    public static double totalDuration = 0;
    public static double totalActionsDuration = 0;
    public static int attempts = 0;

    protected void test_ChatRaid() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();

            // Test ChatApi::CreateChatRaid
            ResultContainer<IChatRaid> raidContainer = new ResultContainer<IChatRaid>();
            ResultContainer<IChatRaid> viewerRaidContainer = new ResultContainer<IChatRaid>();

            class ChatRaidListener implements IChatRaidListener {
                @Override
                public void raidStarted(ChatRaidStatus status) {
                    raidId = status.raidId;
                    System.out.println("Raid started");
                    return;
                }

                @Override
                public void raidUpdated(ChatRaidStatus status) {
                    System.out.println("People in raid: " + status.numUsersInRaid);
                    return;
                }

                @Override
                public void raidFired(ChatRaidStatus status) {
                    System.out.println("Raid completed");
                    return;
                }

                @Override
                public void raidCancelled(ChatRaidStatus status) {
                    System.out.println("Raid cancelled");
                    return;
                }

                public String raidId = null;
            }

            ChatRaidListener chatRaidListener = new ChatRaidListener();
            ChatRaidListener viewerChatRaidListener = new ChatRaidListener();

            callbackCalled.result = false;
            chatApi.createChatRaid(m_UserId, m_UserId, chatRaidListener, raidContainer);
            raidContainer.result.start(0, new IChatRaid.StartCallback() {
                @Override
                public void invoke(ErrorCode ec) {
                    callbackCalled.result = true;
                    return;
                }
            });

            chatApi.createChatRaid(1, 0, viewerChatRaidListener, viewerRaidContainer);

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            while (chatRaidListener.raidId == null) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            viewerRaidContainer.result.join(chatRaidListener.raidId, new IChatRaid.JoinCallback() {
                @Override
                public void invoke(ErrorCode ec) {
                    callbackCalled.result = true;
                    return;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            viewerRaidContainer.result.leave(chatRaidListener.raidId, new IChatRaid.LeaveCallback() {
                @Override
                public void invoke(ErrorCode ec) {
                    callbackCalled.result = true;
                    return;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            raidContainer.result.cancel(new IChatRaid.CancelCallback() {
                @Override
                public void invoke(ErrorCode ec) {
                    callbackCalled.result = true;
                    return;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_FetchBlockedUsers() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();

            callbackCalled.result = false;
            chatApi.fetchBlockedUsers(m_UserId, new ChatAPI.FetchBlockedUsersCallback() {
                @Override
                public void invoke(ErrorCode ec, UserInfo[] users) {
                    callbackCalled.result = true;

                    System.out.println("Blocked Users for User : ");
                    for (UserInfo user : users) {
                        System.out.println("  " + user.userId + " / " + user.userName);
                    }
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_FetchBadges() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;
            chatApi.fetchGlobalBadges(new ChatAPI.FetchBadgesCallback() {
                @Override
                public void invoke(ErrorCode ec, ChatBadgeSet badgeSets) {
                    callbackCalled.result = true;
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
            callbackCalled.result = false;

            ResultContainer<String> threadIdContainer = new ResultContainer<String>();

            chatApi.fetchChannelBadges(m_UserId, new ChatAPI.FetchBadgesCallback() {
                @Override
                public void invoke(ErrorCode ec, ChatBadgeSet badgeSets) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_BitsStatus() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();
        ResultContainer<IBitsStatus> statusContainer = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;

            final IBitsListener bitsListener = new IBitsListener() {
                @Override
                public void userReceivedBits(ChatBitsReceivedEvent bitsReceivedEvent) {
                    callbackCalled.result = true;
                }

                @Override
                public void userSentBits(ChatBitsSentEvent bitsSentEvent) {
                    callbackCalled.result = true;
                }

                @Override
                public void userGainedBits(int bitsBalance) {
                    callbackCalled.result = true;
                }
            };
            chatApi.createBitsStatus(m_UserId, bitsListener, statusContainer);

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            if (statusContainer != null && statusContainer.result != null) {
                BitsStatusProxy proxy = (BitsStatusProxy) statusContainer.result;
                proxy.dispose();
            }
            clearModules();
        }
    }

    protected void test_FollowersStatus() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();
        ResultContainer<IFollowersStatus> statusContainer = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;

            final IFollowersListener followersListener = new IFollowersListener() {
                @Override
                public void newFollowerAdded(ChatFollowerAddedEvent followerAddedEvent) {
                    callbackCalled.result = true;
                }
            };
            chatApi.createFollowersStatus(m_UserId, m_UserId, followersListener, statusContainer);

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            if (statusContainer != null && statusContainer.result != null) {
                FollowersStatusProxy proxy = (FollowersStatusProxy) statusContainer.result;
                proxy.dispose();
            }
            clearModules();
        }
    }

    protected void test_FollowingStatus() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();
        ResultContainer<IFollowingStatus> statusContainer = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;

            final IFollowingListener followingListener = new IFollowingListener() {
                @Override
                public void followedChannel(int userId, int channelId) {
                    callbackCalled.result = true;
                }

                @Override
                public void unfollowedChannel(int userId, int channelId) {
                    callbackCalled.result = true;
                }
            };
            chatApi.createFollowingStatus(m_UserId, followingListener, statusContainer);

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            if (statusContainer != null && statusContainer.result != null) {
                FollowingStatusProxy proxy = (FollowingStatusProxy) statusContainer.result;
                proxy.dispose();
            }
            clearModules();
        }
    }

    protected void test_SubscribersStatus() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();
        ResultContainer<ISubscribersStatus> statusContainer = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;

            final ISubscribersListener subscribersListener = new ISubscribersListener() {
                @Override
                public void newSubscriberAdded(ChatSubscriberAddedEvent subscriberAddedEvent) {
                    callbackCalled.result = true;
                }
            };
            chatApi.createSubscribersStatus(m_UserId, subscribersListener, statusContainer);

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            if (statusContainer != null && statusContainer.result != null) {
                SubscribersStatusProxy proxy = (SubscribersStatusProxy) statusContainer.result;
                proxy.dispose();
            }
            clearModules();
        }
    }

    protected void test_BanUser() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        // For testing purposes - clear these values before you check in
        String bannedUserName = "";

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();

            callbackCalled.result = false;
            chatApi.banUser(m_UserId, m_UserId, bannedUserName, 200, new ChatAPI.BanUserCallback() {
                @Override
                public void invoke(ErrorCode ec, BanUserError error) {
                    callbackCalled.result = true;
                    if (ec.succeeded()) {
                        System.out.println("Timed out user: " + bannedUserName);
                    } else {
                        System.out.println("Timing out users failed");
                    }
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_UnbanUser() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        // For testing purposes - clear these values before you check in
        String bannedUserName = "";

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();

            callbackCalled.result = false;
            chatApi.unbanUser(m_UserId, m_UserId, bannedUserName, new ChatAPI.UnbanUserCallback() {
                @Override
                public void invoke(ErrorCode ec, UnbanUserError error) {
                    callbackCalled.result = true;

                    if (ec.succeeded()) {
                        System.out.println("Unbanned user: " + bannedUserName);
                    } else {
                        System.out.println("Unbanning user failed");
                    }
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_ModUser() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        // For testing purposes - clear these values before you check in
        String modUserName = "";

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();

            callbackCalled.result = false;
            chatApi.modUser(m_UserId, m_UserId, modUserName, new ChatAPI.ModUserCallback() {
                @Override
                public void invoke(ErrorCode ec, ModUserError error) {
                    callbackCalled.result = true;
                    if (ec.succeeded()) {
                        System.out.println("User modded: " + modUserName);
                    } else {
                        System.out.println("Modding user failed");
                    }
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_UnmodUser() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        // For testing purposes - clear these values before you check in
        String unmodUserName = "";

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();

            callbackCalled.result = false;
            chatApi.unmodUser(m_UserId, m_UserId, unmodUserName, new ChatAPI.UnmodUserCallback() {
                @Override
                public void invoke(ErrorCode ec, UnmodUserError error) {
                    callbackCalled.result = true;

                    if (ec.succeeded()) {
                        System.out.println("Unmodded user: " + unmodUserName);
                    } else {
                        System.out.println("Unmodding user failed");
                    }
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_VIP() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        // For testing purposes - clear these values before you check in
        String vipUserName = "null_n";

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();

            callbackCalled.result = false;
            chatApi.grantVIP(m_UserId, m_UserId, vipUserName, new ChatAPI.GrantVIPCallback() {
                @Override
                public void invoke(ErrorCode ec, GrantVIPErrorCode error) {
                    callbackCalled.result = true;
                    if (ec.succeeded()) {
                        System.out.println("User now VIP: " + vipUserName);
                    } else {
                        System.out.println("Granting VIP failed");
                    }
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            chatApi.revokeVIP(m_UserId, m_UserId, vipUserName, new ChatAPI.RevokeVIPCallback() {
                @Override
                public void invoke(ErrorCode ec, RevokeVIPErrorCode error) {
                    callbackCalled.result = true;
                    if (ec.succeeded()) {
                        System.out.println("User no longer VIP: " + vipUserName);
                    } else {
                        System.out.println("Revoking VIP failed");
                    }
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            chatApi.fetchChannelVIPs(m_UserId, new ChatAPI.FetchChannelVIPsCallback() {
                @Override
                public void invoke(ErrorCode ec, String[] vipNames) {
                    callbackCalled.result = true;
                    if (ec.succeeded()) {
                        System.out.print("VIPs in channel: ");
                        for (String name : vipNames) {
                            System.out.println(name);
                        }
                    } else {
                        System.out.println("Failed to fetch VIPs");
                    }
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_UpdateUserColor() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();

            callbackCalled.result = false;
            chatApi.updateUserColor(m_UserId, "blue", new ChatAPI.UpdateUserColorCallback() {
                @Override
                public void invoke(ErrorCode ec) {
                    callbackCalled.result = true;

                    if (ec.succeeded()) {
                        System.out.println("User changed chat color");
                    } else {
                        System.out.println("User failed to change chat color");
                    }
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_FetchChannelModerators() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();

            callbackCalled.result = false;
            chatApi.fetchChannelModerators(m_UserId, null, new ChatAPI.FetchChannelModeratorsCallback() {
                @Override
                public void invoke(ErrorCode ec, String[] names, String nextCursor) {
                    callbackCalled.result = true;

                    if (ec.succeeded()) {
                        System.out.println("Mods in channel: ");
                        for (String name : names) {
                            System.out.println(name);
                        }

                        System.out.println("Next cursor: " + nextCursor);
                    } else {
                        System.out.println("Failed to fetch mods");
                    }
                }
            });
            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_ChatRooms() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();
        ResultContainer<IChannelChatRoomManager> channelChatRoomManagerResult = new ResultContainer<>();
        ResultContainer<IChatRoom> chatRoomResult = new ResultContainer<>();
        ResultContainer<IChatRoomNotifications> chatRoomNotificationsResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        // Replace when testing
        String roomId = "";

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;
            ErrorCode ec;

            IChatRoomNotificationsListener chatRoomNotificationsListener = new IChatRoomNotificationsListener() {
                @Override
                public void userTimedOut(int userId, int channelId, int durationSeconds) {
                    System.out.println("User " + userId + " timed out from channel " + channelId + " for "
                        + durationSeconds + " seconds");
                }

                @Override
                public void userBanned(int userId, int channelId) {
                    System.out.println("User " + userId + " banned from channel " + channelId);
                }

                @Override
                public void userUnbanned(int userId, int channelId) {
                    System.out.println("User " + userId + " unbanned from channel " + channelId);
                }

                @Override
                public void roomViewUpdated(int userId, int ownerId, String roomId, ChatRoomView roomViewInfo) {
                    System.out.println(
                        "User " + userId + " has updated view on room " + roomId + " owned by " + ownerId);
                }

                @Override
                public void roomMentionReceived(int userId, RoomMentionInfo mentionInfo) {
                    System.out.println("User " + userId + " has been mentioned in " + mentionInfo.roomName
                        + " in channel " + mentionInfo.roomOwnerName + " by " + mentionInfo.senderName + " in message "
                        + mentionInfo.messageId);
                }
            };

            ec = chatApi.createChatRoomNotifications(
                m_UserId, chatRoomNotificationsListener, chatRoomNotificationsResult);

            IChannelChatRoomManagerListener channelChatRoomManagerListener = new IChannelChatRoomManagerListener() {
                @Override
                public void purgeMessages(int userId, int channelId, int purgeAfter) {
                    System.out.println("User " + userId + " messages purged from channel " + channelId
                        + " starting from time " + purgeAfter);
                }

                @Override
                public void roomCreated(int ownerId, ChatRoomInfo roomInfo) {
                    System.out.println("Chat room " + roomInfo.name + " created in channel " + ownerId);
                }

                @Override
                public void roomDeleted(int ownerId, ChatRoomInfo roomInfo) {
                    System.out.println("Chat room " + roomInfo.name + " deleted in channel " + ownerId);
                }
            };

            ec = chatApi.createChannelChatRoomManager(
                m_UserId, m_UserId, channelChatRoomManagerListener, channelChatRoomManagerResult);

            callbackCalled.result = false;

            RoomRolePermissions permissions = new RoomRolePermissions();
            permissions.read = RoomRole.Subscriber;
            permissions.send = RoomRole.Moderator;

            ec = channelChatRoomManagerResult.result.addNewChatRoom(
                "java-room", "topic", permissions, new IChannelChatRoomManager.AddRoomCallback() {
                    @Override
                    public void invoke(ErrorCode ec, CreateRoomError error, ChatRoomInfo info) {
                        callbackCalled.result = true;
                    }
                });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = channelChatRoomManagerResult.result.joinChatRooms(new IChannelChatRoomManager.JoinCallback() {
                @Override
                public void invoke(ErrorCode ec) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = channelChatRoomManagerResult.result.leaveChatRooms(new IChannelChatRoomManager.LeaveCallback() {
                @Override
                public void invoke(ErrorCode ec) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = channelChatRoomManagerResult.result.fetchChatRoomsInfo(
                new IChannelChatRoomManager.FetchRoomsInfoCallback() {
                    @Override
                    public void invoke(ErrorCode ec, ChatRoomInfo[] infos) {
                        callbackCalled.result = true;
                    }
                });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            IChatRoomListener chatRoomListener = new IChatRoomListener() {
                @Override
                public void messageReceived(String roomId, ChatRoomMessage message) {
                    System.out.println("Message " + message.roomMessageId + " received");
                }

                @Override
                public void messageEdited(String roomId, ChatRoomMessage message) {
                    System.out.println("Message " + message.roomMessageId + " edited");
                }

                @Override
                public void messageDeleted(String roomId, ChatRoomMessage message) {
                    System.out.println("Message " + message.roomMessageId + " deleted");
                }

                @Override
                public void roomUpdated(ChatRoomInfo roomInfo) {}
            };

            ec = chatApi.createChatRoom(m_UserId, roomId, m_UserId, chatRoomListener, chatRoomResult);

            callbackCalled.result = false;
            ResultContainer<String> messageId = new ResultContainer<>();
            ResultContainer<ChatRoomMessage> placeholderMessageResult = new ResultContainer<>();
            ec = chatRoomResult.result.sendMessage(
                "hello everyone", placeholderMessageResult, new IChatRoom.SendMessageCallback() {
                    @Override
                    public void invoke(ErrorCode ec, SendRoomMessageError error, ChatRoomMessage message) {
                        callbackCalled.result = true;
                        messageId.result = message.roomMessageId;
                    }
                });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.editMessage(
                messageId.result, "edited message", placeholderMessageResult, new IChatRoom.EditMessageCallback() {
                    @Override
                    public void invoke(ErrorCode ec, ChatRoomMessage message) {
                        callbackCalled.result = true;
                    }
                });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.deleteMessage(messageId.result, new IChatRoom.DeleteMessageCallback() {
                @Override
                public void invoke(ErrorCode ec) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.fetchMessagesBeforeCursor("", 5, new IChatRoom.FetchMessagesCallback() {
                @Override
                public void invoke(ErrorCode ec, ChatRoomMessage[] messages, String nextCursor, boolean moreMessages) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.fetchMessagesAfterCursor("", 5, new IChatRoom.FetchMessagesCallback() {
                @Override
                public void invoke(ErrorCode ec, ChatRoomMessage[] messages, String nextCursor, boolean moreMessages) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.fetchMessagesBeforeTimestamp(
                1509431270, 5, new IChatRoom.FetchMessagesCallback() {
                    @Override
                    public void invoke(
                        ErrorCode ec, ChatRoomMessage[] messages, String nextCursor, boolean moreMessages) {
                        callbackCalled.result = true;
                    }
                });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec =
                chatRoomResult.result.fetchMessagesAfterTimestamp(1509431270, 5, new IChatRoom.FetchMessagesCallback() {
                    @Override
                    public void invoke(
                        ErrorCode ec, ChatRoomMessage[] messages, String nextCursor, boolean moreMessages) {
                        callbackCalled.result = true;
                    }
                });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.setRoomName("new-name", new IChatRoom.UpdateRoomInfoCallback() {
                @Override
                public void invoke(ErrorCode ec, UpdateRoomError error, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.setTopic("new topic", new IChatRoom.UpdateRoomInfoCallback() {
                @Override
                public void invoke(ErrorCode ec, UpdateRoomError error, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;

            permissions.read = RoomRole.Moderator;

            ec = chatRoomResult.result.setRoomRolePermissions(permissions, new IChatRoom.UpdateRoomInfoCallback() {
                @Override
                public void invoke(ErrorCode ec, UpdateRoomError error, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.enableSlowMode(60, new IChatRoom.UpdateRoomModesCallback() {
                @Override
                public void invoke(ErrorCode ec, UpdateRoomModesError error, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.disableSlowMode(new IChatRoom.UpdateRoomModesCallback() {
                @Override
                public void invoke(ErrorCode ec, UpdateRoomModesError error, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.enableR9kMode(new IChatRoom.UpdateRoomModesCallback() {
                @Override
                public void invoke(ErrorCode ec, UpdateRoomModesError error, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.disableR9kMode(new IChatRoom.UpdateRoomModesCallback() {
                @Override
                public void invoke(ErrorCode ec, UpdateRoomModesError error, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.enableEmotesOnlyMode(new IChatRoom.UpdateRoomModesCallback() {
                @Override
                public void invoke(ErrorCode ec, UpdateRoomModesError error, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.disableEmotesOnlyMode(new IChatRoom.UpdateRoomModesCallback() {
                @Override
                public void invoke(ErrorCode ec, UpdateRoomModesError error, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.setLastReadAt(11223344, new IChatRoom.UpdateRoomViewCallback() {
                @Override
                public void invoke(ErrorCode ec, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.setMuted(false, new IChatRoom.UpdateRoomViewCallback() {
                @Override
                public void invoke(ErrorCode ec, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.setArchived(false, new IChatRoom.UpdateRoomViewCallback() {
                @Override
                public void invoke(ErrorCode ec, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }

            callbackCalled.result = false;
            ec = chatRoomResult.result.fetchRoomInfo(new IChatRoom.FetchRoomInfoCallback() {
                @Override
                public void invoke(ErrorCode ec, ChatRoomInfo info) {
                    callbackCalled.result = true;
                }
            });

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            if (channelChatRoomManagerResult != null && channelChatRoomManagerResult.result != null) {
                ChannelChatRoomManagerProxy proxy = (ChannelChatRoomManagerProxy) channelChatRoomManagerResult.result;
                proxy.dispose();
            }
            if (chatRoomResult != null && chatRoomResult.result != null) {
                ChatRoomProxy proxy = (ChatRoomProxy) chatRoomResult.result;
                proxy.dispose();
            }
            clearModules();
        }
    }

    protected void test_ChatChannelProperties() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();
        ResultContainer<IChatChannelProperties> propertiesContainer = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;

            final IChatChannelPropertyListener listener = new IChatChannelPropertyListener() {
                @Override
                public void ritualsEnabled(boolean ritualsEnabled) {
                    callbackCalled.result = true;
                }

                @Override
                public void outgoingHostChanged(
                    int channelId, int previousTarget, int currentTarget, String currentTargetName, int numViewers) {
                    callbackCalled.result = true;
                }

                @Override
                public void incomingHostStarted(
                    int channelId, int hostChannelId, String hostChannelName, int numViewers) {
                    callbackCalled.result = true;
                }

                @Override
                public void incomingHostEnded(int channelId, int hostChannelId, String hostChannelName) {
                    callbackCalled.result = true;
                }

                @Override
                public void extensionMessageReceived(ExtensionMessage message) {
                    callbackCalled.result = true;
                }

                @Override
                public void chatChannelRestrictionsReceived(ChatChannelRestrictions restrictions) {
                    callbackCalled.result = true;
                }
            };

            chatApi.createChatChannelProperties(m_UserId, m_UserId, listener, propertiesContainer);

            while (!callbackCalled.result) {
                Thread.sleep(250);
                updateModules();
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            if (propertiesContainer != null && propertiesContainer.result != null) {
                ChatChannelPropertiesProxy proxy = (ChatChannelPropertiesProxy) propertiesContainer.result;
                proxy.dispose();
            }
            clearModules();
        }
    }

    protected void test_CreateChatChannel() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();
        setup(coreApiResult, chatApiResult);

        ResultContainer<IChatChannel> chatChannelResult = new ResultContainer<IChatChannel>();

        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> connected = new ResultContainer<Boolean>();
            connected.result = false;
            final ResultContainer<Boolean> disconnected = new ResultContainer<Boolean>();
            disconnected.result = false;

            ResultContainer<Integer> messageCount = new ResultContainer<Integer>();
            messageCount.result = 0;

            final IChatChannelListener listener = new IChatChannelListener() {
                @Override
                public void chatChannelStateChanged(int userId, int channelId, ChatChannelState state, ErrorCode ec) {
                    System.out.println("Channel state changed:" + state);
                    if (state == ChatChannelState.Connected) {
                        connected.result = true;
                    } else if (state == ChatChannelState.Disconnected) {
                        disconnected.result = true;
                    }
                }

                @Override
                public void chatChannelInfoChanged(int userId, int channelId, ChatChannelInfo channelInfo) {}

                @Override
                public void chatChannelRestrictionsChanged(
                    int userId, int channelId, ChatChannelRestrictions restrictions) {}

                @Override
                public void chatChannelLocalUserChanged(int userId, int channelId, ChatUserInfo userInfo) {}

                @Override
                public void chatChannelMessagesReceived(int userId, int channelId, ChatLiveMessage[] messageList) {
                    System.out.println("Messages received: ");

                    for (ChatLiveMessage message : messageList) {
                        System.out.print("  ");
                        for (ChatMessageToken token : message.messageInfo.tokens) {
                            switch (token.type) {
                                case Bits:
                                    System.out.print(
                                        "$[" + ((ChatBitsToken) token).prefix + ((ChatBitsToken) token).numBits + "]");
                                    break;
                                case Emoticon:
                                    System.out.print("[" + ((ChatEmoticonToken) token).emoticonText + "]");
                                    break;
                                case Mention:
                                    System.out.print("@{" + ((ChatMentionToken) token).text + "}");
                                    break;
                                case Text:
                                    System.out.print("[" + ((ChatTextToken) token).text);
                                    System.out.print(" (Flags: I." + ((ChatTextToken) token).autoModFlags.identityLevel
                                        + "/S." + ((ChatTextToken) token).autoModFlags.sexualLevel + "/A."
                                        + ((ChatTextToken) token).autoModFlags.aggressiveLevel + "/P."
                                        + ((ChatTextToken) token).autoModFlags.profanityLevel + ")]");
                                    break;
                                case Url:
                                    System.out.print("<" + ((ChatUrlToken) token).url + ">");
                                    break;
                                default:
                                    break;
                            }
                        }
                        System.out.print("\n");
                    }
                    messageCount.result++;
                }

                @Override
                public void chatChannelSubscriptionNoticeReceived(
                    int userId, int channelId, ChatSubscriptionNotice notice) {}

                @Override
                public void chatChannelFirstTimeChatterNoticeReceived(
                    int userId, int channelId, ChatFirstTimeChatterNotice notice) {}

                @Override
                public void chatChannelRaidNoticeReceived(int userId, int channelId, ChatRaidNotice notice) {}

                @Override
                public void chatChannelUnraidNoticeReceived(int userId, int channelId, ChatUnraidNotice notice) {}

                @Override
                public void chatChannelGenericNoticeReceived(
                    int userId, int channelId, ChatGenericMessageNotice notice) {}

                @Override
                public void chatChannelMessagesCleared(int userId, int channelId) {}

                @Override
                public void chatChannelUserMessagesCleared(int userId, int channelId, int clearUserId) {}

                @Override
                public void chatChannelHostTargetChanged(
                    int userId, int channelId, String targetChannelName, int numViewers) {}

                @Override
                public void chatChannelNoticeReceived(
                    int userId, int channelId, String noticeId, HashMap<String, String> params) {
                    System.out.println("Channel notice received: " + noticeId);
                }

                @Override
                public void autoModCaughtSentMessage(int userId, int channelId) {}

                @Override
                public void autoModDeniedSentMessage(int userId, int channelId) {}

                @Override
                public void autoModApprovedSentMessage(int userId, int channelId) {}

                @Override
                public void autoModCaughtMessageForMods(int userId, int channelId, String messageId, String message,
                    int senderId, String senderName, String reason) {}

                @Override
                public void autoModMessageApprovedByMod(
                    int userId, int channelId, String messageId, int moderatorId, String moderatorName) {}

                @Override
                public void autoModMessageDeniedByMod(
                    int userId, int channelId, String messageId, int moderatorId, String moderatorName) {}

                @Override
                public void autoModDeniedSentCheer(int userId, int channelId) {}

                @Override
                public void autoModTimedOutSentCheer(int userId, int channelId) {}

                @Override
                public void autoModCaughtCheerForMods(int userId, int channelId, String messageId, String message,
                    int senderId, String senderName, String reason) {}

                @Override
                public void chatChannelModNoticeMessageDeleted(int userId, int channelId,
                    ModerationActionInfo modActionInfo, String messageId, String deletedMessageContent) {}

                @Override
                public void chatChannelModNoticeUserTimedOut(int userId, int channelId,
                    ModerationActionInfo modActionInfo, int timeoutDurationSeconds, String reason) {}

                @Override
                public void chatChannelModNoticeUserBanned(
                    int userId, int channelId, ModerationActionInfo modActionInfo, String reason) {}

                @Override
                public void chatChannelModNoticeUserUntimedOut(
                    int userId, int channelId, ModerationActionInfo modActionInfo) {}

                @Override
                public void chatChannelModNoticeUserUnbanned(
                    int userId, int channelId, ModerationActionInfo modActionInfo) {}

                @Override
                public void chatChannelModNoticeClearChat(int userId, int channelId, int modId, String modName) {}

                @Override
                public void chatChannelModNoticeEmoteOnly(int userId, int channelId, int modId, String modName) {}

                @Override
                public void chatChannelModNoticeEmoteOnlyOff(int userId, int channelId, int modId, String modName) {}

                @Override
                public void chatChannelModNoticeFollowersOnly(
                    int userId, int channelId, int modId, String modName, int minimumFollowingDuration) {}

                @Override
                public void chatChannelModNoticeFollowersOnlyOff(int userId, int channelId, int modId, String modName) {
                }

                @Override
                public void chatChannelModNoticeR9K(int userId, int channelId, int modId, String modName) {}

                @Override
                public void chatChannelModNoticeR9KOff(int userId, int channelId, int modId, String modName) {}

                @Override
                public void chatChannelModNoticeSlow(
                    int userId, int channelId, int modId, String modName, int slowModeDurationSeconds) {}

                @Override
                public void chatChannelModNoticeSlowOff(int userId, int channelId, int modId, String modName) {}

                @Override
                public void chatChannelModNoticeSubsOnly(int userId, int channelId, int modId, String modName) {}

                @Override
                public void chatChannelModNoticeSubsOnlyOff(int userId, int channelId, int modId, String modName) {}

                @Override
                public void chatChannelMessageDeleted(int userId, int channelId, String messageId,
                    String senderLoginName, String deletedMessageContent) {}
            };

            int channelIdToJoin = -1; // Fill this out with a valid channelId to test.

            ErrorCode ec = chatApi.createChatChannel(m_UserId, channelIdToJoin, listener, chatChannelResult);
            System.out.println("createChatChannel: " + ec.getName());

            IChatChannel chatChannel = chatChannelResult.result;
            ec = chatChannel.connect();
            System.out.println("connect: " + ec.getName());

            while (!connected.result) {
                coreApi.update();
                chatApi.update();
                Thread.sleep(100);
            }

            ec = chatChannel.sendMessage("Hey chat HeyGuys");
            System.out.println("sendMessage: " + ec.getName());

            while (messageCount.result < 20) {
                coreApi.update();
                chatApi.update();
                Thread.sleep(100);
            }

            ec = chatChannel.disconnect();
            System.out.println("disconnect: " + ec.getName());

            while (!disconnected.result) {
                coreApi.update();
                chatApi.update();
                Thread.sleep(100);
            }
        } finally {
            if (chatChannelResult.result != null) {
                chatChannelResult.result.dispose();
            }

            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_ChatCommentManager() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;

            final IChatCommentListener listener = new IChatCommentListener() {
                @Override
                public void chatCommentManagerStateChanged(int userId, String vodId, PlayingState state) {}

                @Override
                public void chatCommentsReceived(int userId, String vodId, ChatComment[] messageList) {
                    callbackCalled.result = true;
                }

                @Override
                public void chatCommentsErrorReceived(String errorMsg, int ec) {}
            };

            Result<IChatCommentManager> result = chatApi.createChatCommentManager(m_UserId, "1234", listener);

            if (result.isSuccess()) {
                IChatCommentManager manager = result.getResult();

                manager.play();

                while (!callbackCalled.result) {
                    Thread.sleep(250);
                    updateModules();
                }

                manager.pause();
                Result<Integer> channelId = manager.getChannelId();
                if (channelId.isSuccess()) {
                    int id = channelId.getResult();
                }

                Result<Integer> playheadTime = manager.getPlayheadTime();
                if (playheadTime.isSuccess()) {
                    int time = playheadTime.getResult();
                }

                manager.updatePlayhead(11000);
                manager.play();
                callbackCalled.result = false;

                while (!callbackCalled.result) {
                    Thread.sleep(250);
                    updateModules();
                }
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_SubscriptionsNotifications() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;

            final ISubscriptionsNotificationsListener listener = new ISubscriptionsNotificationsListener() {
                @Override
                public void subscribedToChannel(int userId, int channelId) {
                    callbackCalled.result = true;
                }
            };

            Result<ISubscriptionsNotifications> result = chatApi.createSubscriptionsNotifications(m_UserId, listener);

            if (result.isSuccess()) {
                while (!callbackCalled.result) {
                    Thread.sleep(250);
                    updateModules();
                }
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_SquadNotifications() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        // Replace when testing
        String squadId = "";

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;

            final ISquadNotificationsListener listener = new ISquadNotificationsListener() {
                @Override
                public void squadUpdated(SquadInfo squad) {
                    callbackCalled.result = true;
                }

                @Override
                public void squadEnded() {
                    callbackCalled.result = true;
                }
            };

            Result<ISquadNotifications> result = chatApi.createSquadNotifications(m_UserId, squadId, listener);

            if (result.isSuccess()) {
                while (!callbackCalled.result) {
                    Thread.sleep(250);
                    updateModules();
                }
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_MultiviewNotifications() throws Exception {
        ResultContainer<CoreAPI> coreApiResult = new ResultContainer<>();
        ResultContainer<ChatAPI> chatApiResult = new ResultContainer<>();

        setup(coreApiResult, chatApiResult);
        CoreAPI coreApi = coreApiResult.result;
        ChatAPI chatApi = chatApiResult.result;

        // Replace when testing
        int channelId = 0;

        try {
            final ResultContainer<Boolean> callbackCalled = new ResultContainer<Boolean>();
            callbackCalled.result = false;

            final IMultiviewNotificationsListener listener = new IMultiviewNotificationsListener() {
                @Override
                public void chanletUpdated(int userId, int channelId, Chanlet chanlet) {
                    callbackCalled.result = true;
                }
            };

            Result<IMultiviewNotifications> result =
                chatApi.createMultiviewNotifications(m_UserId, channelId, listener);

            if (result.isSuccess()) {
                while (!callbackCalled.result) {
                    Thread.sleep(250);
                    updateModules();
                }
            }
        } finally {
            if (chatApi != null) {
                chatApi.shutdown(null);
                while (chatApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                chatApi.dispose();
            }
            if (coreApi != null) {
                coreApi.shutdown(null);
                while (coreApi.getState() != ModuleState.Uninitialized) {
                    Thread.sleep(250);
                    updateModules();
                }
                coreApi.dispose();
            }
            clearModules();
        }
    }

    protected void test_JniChatWhisperMessage() throws Exception {
        ChatWhisperMessage expected = new ChatWhisperMessage();
        expected.messageId = 1;
        expected.messageUuid = "message_uuid";
        expected.threadId = "thread_id";

        ChatWhisperMessage result = Test_JniChatWhisperMessage();
        ExpectEqual(expected.messageId, result.messageId);
        ExpectEqual(expected.messageUuid, result.messageUuid);
        ExpectEqual(expected.threadId, result.threadId);
    }
}
