import argparse
import imp
import os

# Load the generator script as a module we can call into
tools_dir = os.path.realpath(os.path.dirname(__file__))
generate_module = imp.load_source('generate_class_info_func', os.path.join(tools_dir, '..', '..', '..', '..', 'build/tools/bindings/java', 'generate_native_java_class_info.py'))

generated_header_paths = []

def generate(class_names):

    # Generate each type we care about
    for class_name in class_names:
        sanitized_class_name = class_name.lower().replace('$', '_')

        hpp = hpp_prefix + 'java_' + sanitized_class_name.lower() + '.h'
        cpp = cpp_prefix + 'java_' + sanitized_class_name.lower() + '.cpp'

        class_name = java_namespace + '.' + class_name

        generate_module.generate(
            java_class_name=class_name,
            class_path=class_path,
            hpp_path=hpp,
            cpp_path=cpp,
            pch_path=pch,
            namespace=cpp_namespace)

        generated_header_paths.append(hpp)


# Classes
class_names = [
    'ChatAPI$BlockChangeCallback',
    'ChatAPI$FetchEmoticonSetsCallback',
    'ChatAPI$FetchBadgesCallback',
    'ChatAPI$SendMessageCallback',
    'ChatAPI$FetchBlockedUsersCallback',
    'ChatAPI$BanUserCallback',
    'ChatAPI$UnbanUserCallback',
    'ChatAPI$ModUserCallback',
    'ChatAPI$UnmodUserCallback',
    'ChatAPI$GrantVIPCallback',
    'ChatAPI$RevokeVIPCallback',
    'ChatAPI$UpdateUserColorCallback',
    'ChatAPI$FetchChannelModeratorsCallback',
    'ChatAPI$FetchChannelVIPsCallback',
    'ChatAPI$FetchChannelVodCommentSettingsCallback',
    'ChatAPI$SetChannelVodCommentSettingsCallback',
    'IChatRaid$JoinCallback',
    'IChatRaid$LeaveCallback',
    'IChatRaid$StartCallback',
    'IChatRaid$RaidNowCallback',
    'IChatRaid$CancelCallback',
    'IChannelChatRoomManager$JoinCallback',
    'IChannelChatRoomManager$LeaveCallback',
    'IChannelChatRoomManager$AddRoomCallback',
    'IChannelChatRoomManager$FetchRoomsInfoCallback',
    'IChatCommentManager$FetchCommentsCallback',
    'IChatCommentManager$FetchCommentCallback',
    'IChatCommentManager$DeleteCommentCallback',
    'IChatCommentManager$PostCommentCallback',
    'IChatCommentManager$ReportCommentCallback',
    'IChatCommentManager$FetchCommentRepliesCallback',
    'IChatCommentManager$PostCommentReplyCallback',
    'IChatRoom$DeleteRoomCallback',
    'IChatRoom$SendMessageCallback',
    'IChatRoom$EditMessageCallback',
    'IChatRoom$DeleteMessageCallback',
    'IChatRoom$FetchMessagesCallback',
    'IChatRoom$UpdateRoomInfoCallback',
    'IChatRoom$UpdateRoomModesCallback',
    'IChatRoom$UpdateRoomViewCallback',
    'IChatRoom$FetchRoomInfoCallback',
    'ChatMessageHandler$ICallbacks',
    'ChatRoomMessageHandler$ICallbacks',
    'ChatRoomMessageHandler$CommandError',
    'AutoModFlags',
    'BitsStatusProxy',
    'Chanlet',
    'ChannelChatRoomManagerProxy',
    'ChannelVodCommentSettings',
    'ChatBadge',
    'ChatBadgeAction',
    'ChatBadgeEntitlement',
    'ChatBadgeImage',
    'ChatBadgeSet',
    'ChatBadgeVersion',
    'ChatBitsReceivedEvent',
    'ChatBitsSentEvent',
    'ChatBitsToken',
    'ChatChannelInfo',
    'ChatChannelPropertiesProxy',
    'ChatChannelProxy',
    'ChatChannelRestrictions',
    'ChatChannelState',
    'ChatComment',
    'ChatCommentManagerProxy',
    'ChatCommentPublishedState',
    'ChatCommentSource',
    'ChatEmoticon',
    'ChatEmoticonSet',
    'ChatEmoticonToken',
    'ChatFeatureFlags',
    'ChatFirstTimeChatterNotice',
    'ChatFollowerAddedEvent',
    'ChatGenericMessageNotice',
    'ChatGraphQLErrorCode',
    'ChatLiveMessage',
    'ChatMentionToken',
    'ChatMessageInfo',
    'ChatMessageBadge',
    'ChatMessageFlags',
    'ChatMessageToken',
    'ChatMessageTokenType',
    'ChatModeInfo',
    'ChatRaidProxy',
    'ChatRaidStatus',
    'ChatRaidNotice',
    'ChatRestrictionReason',
    'ChatRoomInfo',
    'ChatRoomNotificationsProxy',
    'ChatRoomMessage',
    'ChatRoomPermissions',
    'ChatRoomProxy',
    'ChatRoomView',
    'ChatSubscriberAddedEvent',
    'ChatSubscriptionNotice',
    'ChatSubscriptionNoticeType',
    'ChatSubscriptionNoticePlan',
    'ChatSubscriptionNoticeRecipient',
    'ChatTextToken',
    'ChatTokenizationOptions',
    'ChatUnraidNotice',
    'ChatUrlToken',
    'ChatUserInfo',
    'ChatUserMode',
    'ChatWhisperMessage',
    'CommentPublishingMode',
    'CreateRoomError',
    'ExtensionMessage',
    'FollowersStatusProxy',
    'FollowingStatusProxy',
    'GrantVIPErrorCode',
    'IBitsListener',
    'IBitsStatus',
    'IChatAPIListener',
    'IChatChannel',
    'IChatChannelListener',
    'IChatCommentManager',
    'IChatCommentListener',
    'IChatRaid',
    'IChatRaidListener',
    'IChatRoom',
    'IChatRoomListener',
    'IChannelChatRoomManager',
    'IChannelChatRoomManagerListener',
    'IChatRoomNotifications',
    'IChatRoomNotificationsListener',
    'IChatChannelProperties',
    'IChatChannelPropertyListener',
    'IChatUserThreadsListener',
    'IFollowersListener',
    'IFollowersStatus',
    'IFollowingListener',
    'IFollowingStatus',
    'IMultiviewNotifications',
    'IMultiviewNotificationsListener',
    'ISubscribersListener',
    'ISubscribersStatus',
    'ISubscriptionsNotifications',
    'ISubscriptionsNotificationsListener',
    'ISquadNotifications',
    'ISquadNotificationsListener',
    'ModerationActionInfo',
    'MultiviewContentAttribute',
    'MultiviewNotificationsProxy',
    'PlayingState',
    'RevokeVIPErrorCode',
    'RoomMentionInfo',
    'RoomRole',
    'RoomRolePermissions',
    'SendRoomMessageError',
    'SubscribersStatusProxy',
    'SubscriptionsNotificationsProxy',
    'SquadNotificationsProxy',
    'UpdateRoomError',
    'UpdateRoomModesError',
    'BanUserError',
    'UnbanUserError',
    'ModUserError',
    'UnmodUserError'
]

try:
    class_path = os.environ['TTV_JAVA_BINDINGS_BIN_PATH']
except KeyError:
    raise EnvironmentError('Set TTV_JAVA_BINDINGS_BIN_PATH environment variable to use.')

java_namespace = 'tv.twitch.chat'
cpp_namespace = 'ttv::binding::java'
hpp_prefix = os.path.join(tools_dir, '../include/twitchsdk/chat/generated/')
cpp_prefix = os.path.join(tools_dir, '../source/generated/')
pch = 'twitchsdk/chat/internal/pch.h'

dest_dir = os.path.realpath(os.path.dirname(hpp_prefix))
if not os.path.exists(dest_dir):
    os.makedirs(dest_dir)

dest_dir = os.path.realpath(os.path.dirname(cpp_prefix))
if not os.path.exists(dest_dir):
    os.makedirs(dest_dir)

generate(class_names)


# Generate the header file to include all the generated header files
master_header_path = hpp_prefix + 'java_all.h'
file = open(master_header_path, 'w')
file.write(generate_module.copyright() + """#pragma once

""")

for path in generated_header_paths:
    include_path = generate_module.determine_header_include_path(path)

    if include_path:
        file.write('#include "' + include_path + '"' + "\n")


file.write("\n")
file.close()
