##########################################################################################################
#
# Fragment: chat_win32
#
# See README.md for fragment documentation.
#
##########################################################################################################

import os
import glob
import build_types
import build_tools

def load_twitchsdk_fragment(primitives, options):

    fragment = build_types.SourceFragment('twitchsdk', 'chat_win32', os.path.dirname(os.path.realpath(__file__)))

    # Preprocessor defines
    fragment.add_preprocessor_definition('TTV_CHAT_INCLUDE_PCH_PLATFORM')

    # Use custom implementation of certain C++11 features
    if options.compiler == "vs2010" or options.compiler == "vs2012":
        fragment.add_preprocessor_definition('TTV_INCLUDE_CPPTRANSITIONS')

    # Header files
    build_tools.add_source_files_recursively(fragment, 'include/twitchsdk/chat', ['.h'], 'Header Files/chat/common')

    fragment.add_header_files( os.path.join(fragment.root_path, "include/twitchsdk/chat/internal/pch_platform.h") )

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )

    return fragment
