##########################################################################################################
#
# Fragment: core_android
#
# See README.md for fragment documentation.
#
##########################################################################################################

import glob
import os
import build_types

def load_twitchsdk_fragment(primitives, options):

    fragment = build_types.SourceFragment('twitchsdk', 'core_android', os.path.dirname(os.path.realpath(__file__)))

    # Pull in primitives
    use_all_implementations = options.has_setting('TTV_USEALL_ANDROID_IMPLEMENTATIONS')

    if not primitives.implemented('MEMORY'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/androidmemory.cpp") )
        primitives.set('MEMORY', None)

    if not primitives.implemented('ASSERT'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/androidassert.cpp") )
        primitives.set('ASSERT', None)

    if use_all_implementations or options.has_setting('TTV_USE_ANDROID_TRACER'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/androidtracer.cpp") )
        fragment.add_header_files( os.path.join(fragment.root_path, "include/twitchsdk/core/androidtracer.h") )

        if not primitives.implemented('TRACER'):
            primitives.set('TRACER', "ttv::AndroidTracer", "twitchsdk/core/androidtracer.h")

    fragment.add_source_group("Source Files/core/android", fragment.source_files)
    fragment.add_source_group("Header Files/core/android", fragment.header_files)

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )

    return fragment
