/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/
#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/androidtracer.h"

#include <android/log.h>

void ttv::AndroidTracer::Log(const char* component, const char* messageLevel, const char* format, va_list args) {
  // Print the line prefix
  GetLinePrefix(component, messageLevel, &mPrintBuffer[0], mPrintBuffer.size());

  if (mTraceFile != nullptr) {
    LogToFile(&mPrintBuffer[0]);
  }

  // Print the message
  vsnprintf(&mPrintBuffer[0], mPrintBuffer.size() - 1, format, args);
  mPrintBuffer[mPrintBuffer.size() - 1] = '\0';

  if (mTraceFile != nullptr) {
    LogToFile(&mPrintBuffer[0]);
  }

  __android_log_print(ANDROID_LOG_DEBUG, "twitchsdk", "%s", &mPrintBuffer[0]);
  printf("%s\n", &mPrintBuffer[0]);
}
