/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/channel/ichannelstatus.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"

#include <memory>

namespace ttv {
class IChannelListener;
class ChannelStatus;
}  // namespace ttv

/**
 * A concrete implemenation of IChannelStatus.
 */
class ttv::ChannelStatus : public ttv::PubSubComponent<IChannelListener>, public IChannelStatus {
 public:
  using DisposerFunc = std::function<void()>;

 public:
  ChannelStatus(const std::shared_ptr<User>& user, ChannelId channelId);

  // IChannelStatus Implementation
  virtual TTV_ErrorCode Dispose() override;
  virtual TTV_ErrorCode UploadProfileImage(
    const char* imageBuffer, size_t imageSize, const UploadProfileImageCallback& callback) override;

  virtual TTV_ErrorCode Initialize() override;
  virtual void Update() override;

  static std::string GetComponentName() { return "ttv::ChannelStatus"; }
  virtual std::string GetLoggerName() const override;

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const json::Value& msg) override;

 protected:
  // Component overrides
  virtual bool CheckShutdown() override;
  virtual void CompleteShutdown() override;

 private:
  std::shared_ptr<ComponentContainer> mComponentContainer;
  std::string mStreamUpdatePubSubTopic;
  std::string mVideoStreamPubSubTopic;
  std::string mChannelSquadUpdatesPubSubTopic;
  std::string mAdPropertyRefreshPubSubTopic;
  ChannelId mChannelId;
};
