/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/module.h"
#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"

#include <memory>
#include <vector>

namespace ttv {
class ICoreAPIListener;
}

class ttv::ICoreAPIListener : public ttv::IModuleListener {
 public:
  /**
   * Called when a user login operation has finished.
   */
  virtual void CoreUserLoginComplete(
    const std::string& oauthToken, UserId userId, const ErrorDetails& errorDetails) = 0;
  /**
   * Called when a user logout operation has finished.
   */
  virtual void CoreUserLogoutComplete(UserId userId, TTV_ErrorCode ec) = 0;
  /**
   * Called when an authentication issue occurs.
   */
  virtual void CoreUserAuthenticationIssue(
    UserId userId, const std::string& oauthToken, const ErrorDetails& errorDetails) = 0;

  virtual void CorePubSubStateChanged(UserId userId, PubSubState state, TTV_ErrorCode ec) = 0;
};
