/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/idashboardactivitylistener.h"
#include "twitchsdk/core/idashboardactivitystatus.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"
#include "twitchsdk/core/types/dashboardtypes.h"
#include "twitchsdk/core/user/user.h"

namespace ttv {
class DashboardActivityStatus;
}  // namespace ttv

class ttv::DashboardActivityStatus : public IDashboardActivityStatus,
                                     public PubSubComponent<IDashboardActivityListener> {
 public:
  DashboardActivityStatus(const std::shared_ptr<User>& user, ChannelId channelId);
  ~DashboardActivityStatus() override = default;

  // Component Overrides
  static std::string GetComponentName() { return "ttv::DashboardActivityStatus"; }
  std::string GetLoggerName() const override;

  // IDashboardActivityStatus implementation
  TTV_ErrorCode Dispose() override;

  void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  void OnTopicMessageReceived(const std::string& topic, const ttv::json::Value& jRoot) override;

 private:
  void HandleBitsUseage(const ttv::json::Value& jMessage);
  void HandleFollow(const ttv::json::Value& jMessage);
  void HandleAutoHostStart(const ttv::json::Value& jMessage);
  void HandleHostStart(const ttv::json::Value& jMessage);
  void HandleRaiding(const ttv::json::Value& jMessage);
  void HandlePrimeSubscription(const ttv::json::Value& jMessage);
  void HandleSubscription(const ttv::json::Value& jMessage);
  void HandlePrimeResubscriptionSharing(const ttv::json::Value& jMessage);
  void HandleResubscriptionSharing(const ttv::json::Value& jMessage);
  void HandleSubscriptionGiftingCommunity(const ttv::json::Value& jMessage);
  void HandleSubscriptionGiftingIndividual(const ttv::json::Value& jMessage);
  void HandleStreamUp(const ttv::json::Value& jMessage);

  std::string mPubSubTopic;
};
