/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/igenericsubscriberlistener.h"
#include "twitchsdk/core/igenericsubscriberstatus.h"
#include "twitchsdk/core/pubsub/pubsubcomponent.h"
#include "twitchsdk/core/user/user.h"

namespace ttv {
class GenericSubscriberStatus;
}  // namespace ttv

class ttv::GenericSubscriberStatus : public IGenericSubscriberStatus,
                                     public PubSubComponent<IGenericSubscriberListener> {
 public:
  GenericSubscriberStatus(const std::shared_ptr<User>& user, const std::string& subscriberTopic);
  virtual ~GenericSubscriberStatus() override = default;

  // Component Overrides
  static std::string GetComponentName() { return "ttv::GenericSubscriberStatus"; }
  virtual std::string GetLoggerName() const override;

  // IGenericSubscriberStatus implementation
  virtual TTV_ErrorCode Dispose() override;

  virtual void OnTopicSubscribeStateChanged(
    const std::string& topic, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode ec) override;
  virtual void OnTopicMessageReceived(const std::string& topic, const ttv::json::Value& jRoot) override;

 private:
  std::string mPubSubTopic;
};
