/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/dashboardtypes.h"

#include <string>
#include <vector>

namespace ttv {
class IDashboardActivityListener;
class DashboardActivityListenerProxy;
}  // namespace ttv

class ttv::IDashboardActivityListener {
 public:
  IDashboardActivityListener() = default;
  virtual ~IDashboardActivityListener() = default;

  virtual void EventBitsUseage(const DashboardActivityBitsUsage& data) = 0;
  virtual void EventFollower(const DashboardActivityFollow& data) = 0;
  virtual void EventAutoHostStart(const DashboardActivityHost& data) = 0;
  virtual void EventHostStart(const DashboardActivityHost& data) = 0;
  virtual void EventRaiding(const DashboardActivityRaiding& data) = 0;
  virtual void EventSubscription(const DashboardActivitySubscription& data) = 0;
  virtual void EventPrimeSubscription(const DashboardActivitySubscription& data) = 0;
  virtual void EventResubscriptionSharing(const DashboardActivityResubscriptionSharing& data) = 0;
  virtual void EventPrimeResubscriptionSharing(const DashboardActivityResubscriptionSharing& data) = 0;
  virtual void EventSubscriptionGiftingCommunity(const DashboardActivitySubscriptionGiftingCommunity& data) = 0;
  virtual void EventSubscriptionGiftingIndividual(const DashboardActivitySubscriptionGiftingIndividual& data) = 0;
  virtual void EventStreamUp(const DashboardActivityHeader& data) = 0;
};
