/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/errortypes.h"

namespace ttv {
class IGenericSubscriberStatus;
}  // namespace ttv

/**
 * The interface for receiving GenericSubscriber data for user.
 */
class ttv::IGenericSubscriberStatus {
 public:
  virtual ~IGenericSubscriberStatus() = default;

  /**
   * This should be called when the application is done with the instance.
   */
  virtual TTV_ErrorCode Dispose() = 0;
};
