/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace core
    {
        namespace graphql
        {
            namespace json
            {
                struct GetChannelGame;
                struct GetChannelBroadcast;
                struct GetChannelBroadcastSettings;
                struct GetChannelFollowerConnection;
                struct GetChannelUserRoles;
                struct GetChannelPayloadType;
                struct GetChannelInputParams;
                struct GetChannelLanguage;
            }

            struct GetChannelQueryInfo
            {
                enum class Language
                {
                    AR,
                    ASL,
                    BG,
                    CA,
                    CS,
                    DA,
                    DE,
                    EL,
                    EN,
                    ES,
                    FI,
                    FR,
                    HI,
                    HU,
                    ID,
                    IT,
                    JA,
                    KO,
                    MS,
                    NL,
                    NO,
                    OTHER,
                    PL,
                    PT,
                    RO,
                    RU,
                    SK,
                    SV,
                    TH,
                    TL,
                    TR,
                    UK,
                    VI,
                    ZH,
                    ZH_HK,
                };

                struct Game
                {
                    std::string name;
                };

                struct Broadcast
                {
                    ttv::Optional<Game> game;
                    ttv::Optional<std::string> title;
                };

                struct BroadcastSettings
                {
                    Language language;
                    bool isMature;
                };

                struct FollowerConnection
                {
                    ttv::Optional<int32_t> totalCount;
                };

                struct UserRoles
                {
                    ttv::Optional<bool> isAffiliate;
                    ttv::Optional<bool> isPartner;
                };

                struct PayloadType
                {
                    ttv::Optional<std::string> displayName;
                    ttv::Optional<std::string> login;
                    ttv::Optional<Broadcast> lastBroadcast;
                    ttv::Optional<std::string> description;
                    ttv::Optional<BroadcastSettings> broadcastSettings;
                    ttv::Optional<std::string> profileImageURL;
                    ttv::Optional<std::string> profileURL;
                    ttv::Optional<std::string> offlineImageURL;
                    ttv::Optional<std::string> bannerImageURL;
                    std::string id;
                    ttv::Optional<ttv::Timestamp> createdAt;
                    ttv::Optional<ttv::Timestamp> updatedAt;
                    ttv::Optional<FollowerConnection> followers;
                    ttv::Optional<int32_t> profileViewCount;
                    ttv::Optional<UserRoles> roles;
                };

                struct InputParams
                {
                    std::string authToken;
                    ttv::Optional<std::string> userID;
                };

                static constexpr const char* kTaskName = "GraphQLTask: GetChannel";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query GetChannel($userID:ID) {
                        user(id:$userID) {
                            displayName
                            login
                            lastBroadcast {
                                game {
                                    name
                                }
                                title
                            }
                            description
                            broadcastSettings {
                                language
                                isMature
                            }
                            profileImageURL(width:300)
                            profileURL
                            offlineImageURL # videoBannerImageUrl
                            bannerImageURL # profileBannerImageUrl
                            id
                            createdAt
                            updatedAt
                            followers {
                                totalCount
                            }
                            profileViewCount
                            roles {
                                isAffiliate
                                isPartner
                            }
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::core::graphql::json::GetChannelGame
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& game)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("name", game.name)
        );
    }
};


struct ttv::core::graphql::json::GetChannelBroadcast
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& broadcast)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("game", broadcast.game),
            make_field<OptionalField>("title", broadcast.title)
        );
    }
};


struct ttv::core::graphql::json::GetChannelBroadcastSettings
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& broadcastSettings)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("language", broadcastSettings.language),
            make_field<RequiredField>("isMature", broadcastSettings.isMature)
        );
    }
};


struct ttv::core::graphql::json::GetChannelFollowerConnection
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& followerConnection)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("totalCount", followerConnection.totalCount)
        );
    }
};


struct ttv::core::graphql::json::GetChannelUserRoles
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& userRoles)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("isAffiliate", userRoles.isAffiliate),
            make_field<OptionalField>("isPartner", userRoles.isPartner)
        );
    }
};


struct ttv::core::graphql::json::GetChannelPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>(MakeKeyPath("user", "displayName"), payloadType.displayName),
            make_field<OptionalField>(MakeKeyPath("user", "login"), payloadType.login),
            make_field<OptionalField>(MakeKeyPath("user", "lastBroadcast"), payloadType.lastBroadcast),
            make_field<OptionalField>(MakeKeyPath("user", "description"), payloadType.description),
            make_field<OptionalField>(MakeKeyPath("user", "broadcastSettings"), payloadType.broadcastSettings),
            make_field<OptionalField>(MakeKeyPath("user", "profileImageURL"), payloadType.profileImageURL),
            make_field<OptionalField>(MakeKeyPath("user", "profileURL"), payloadType.profileURL),
            make_field<OptionalField>(MakeKeyPath("user", "offlineImageURL"), payloadType.offlineImageURL),
            make_field<OptionalField>(MakeKeyPath("user", "bannerImageURL"), payloadType.bannerImageURL),
            make_field<RequiredField>(MakeKeyPath("user", "id"), payloadType.id),
            make_field<OptionalField>(MakeKeyPath("user", "createdAt"), payloadType.createdAt),
            make_field<OptionalField>(MakeKeyPath("user", "updatedAt"), payloadType.updatedAt),
            make_field<OptionalField>(MakeKeyPath("user", "followers"), payloadType.followers),
            make_field<OptionalField>(MakeKeyPath("user", "profileViewCount"), payloadType.profileViewCount),
            make_field<OptionalField>(MakeKeyPath("user", "roles"), payloadType.roles)
        );
    }
};


struct ttv::core::graphql::json::GetChannelInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("userID", inputParams.userID)
        );
    }
};


struct ttv::core::graphql::json::GetChannelLanguage
{
    static auto EnumMap()
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_enum_mapping_case_insensitive("AR", GetChannelQueryInfo::Language::AR),
            make_enum_mapping_case_insensitive("ASL", GetChannelQueryInfo::Language::ASL),
            make_enum_mapping_case_insensitive("BG", GetChannelQueryInfo::Language::BG),
            make_enum_mapping_case_insensitive("CA", GetChannelQueryInfo::Language::CA),
            make_enum_mapping_case_insensitive("CS", GetChannelQueryInfo::Language::CS),
            make_enum_mapping_case_insensitive("DA", GetChannelQueryInfo::Language::DA),
            make_enum_mapping_case_insensitive("DE", GetChannelQueryInfo::Language::DE),
            make_enum_mapping_case_insensitive("EL", GetChannelQueryInfo::Language::EL),
            make_enum_mapping_case_insensitive("EN", GetChannelQueryInfo::Language::EN),
            make_enum_mapping_case_insensitive("ES", GetChannelQueryInfo::Language::ES),
            make_enum_mapping_case_insensitive("FI", GetChannelQueryInfo::Language::FI),
            make_enum_mapping_case_insensitive("FR", GetChannelQueryInfo::Language::FR),
            make_enum_mapping_case_insensitive("HI", GetChannelQueryInfo::Language::HI),
            make_enum_mapping_case_insensitive("HU", GetChannelQueryInfo::Language::HU),
            make_enum_mapping_case_insensitive("ID", GetChannelQueryInfo::Language::ID),
            make_enum_mapping_case_insensitive("IT", GetChannelQueryInfo::Language::IT),
            make_enum_mapping_case_insensitive("JA", GetChannelQueryInfo::Language::JA),
            make_enum_mapping_case_insensitive("KO", GetChannelQueryInfo::Language::KO),
            make_enum_mapping_case_insensitive("MS", GetChannelQueryInfo::Language::MS),
            make_enum_mapping_case_insensitive("NL", GetChannelQueryInfo::Language::NL),
            make_enum_mapping_case_insensitive("NO", GetChannelQueryInfo::Language::NO),
            make_enum_mapping_case_insensitive("OTHER", GetChannelQueryInfo::Language::OTHER),
            make_enum_mapping_case_insensitive("PL", GetChannelQueryInfo::Language::PL),
            make_enum_mapping_case_insensitive("PT", GetChannelQueryInfo::Language::PT),
            make_enum_mapping_case_insensitive("RO", GetChannelQueryInfo::Language::RO),
            make_enum_mapping_case_insensitive("RU", GetChannelQueryInfo::Language::RU),
            make_enum_mapping_case_insensitive("SK", GetChannelQueryInfo::Language::SK),
            make_enum_mapping_case_insensitive("SV", GetChannelQueryInfo::Language::SV),
            make_enum_mapping_case_insensitive("TH", GetChannelQueryInfo::Language::TH),
            make_enum_mapping_case_insensitive("TL", GetChannelQueryInfo::Language::TL),
            make_enum_mapping_case_insensitive("TR", GetChannelQueryInfo::Language::TR),
            make_enum_mapping_case_insensitive("UK", GetChannelQueryInfo::Language::UK),
            make_enum_mapping_case_insensitive("VI", GetChannelQueryInfo::Language::VI),
            make_enum_mapping_case_insensitive("ZH", GetChannelQueryInfo::Language::ZH),
            make_enum_mapping_case_insensitive("ZH_HK", GetChannelQueryInfo::Language::ZH_HK)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetChannelQueryInfo::Game>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetChannelGame>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetChannelQueryInfo::Broadcast>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetChannelBroadcast>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetChannelQueryInfo::BroadcastSettings>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetChannelBroadcastSettings>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetChannelQueryInfo::FollowerConnection>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetChannelFollowerConnection>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetChannelQueryInfo::UserRoles>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetChannelUserRoles>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetChannelQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetChannelPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetChannelQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetChannelInputParams>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetChannelQueryInfo::Language>
{
    using Type = EnumSchema<ttv::core::graphql::json::GetChannelLanguage>;
};
