/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace core
    {
        namespace graphql
        {
            namespace json
            {
                struct GetCurrentUserPayloadType;
                struct GetCurrentUserInputParams;
            }

            struct GetCurrentUserQueryInfo
            {
                struct PayloadType
                {
                    ttv::Optional<std::string> login;
                    ttv::Optional<std::string> displayName;
                    ttv::Optional<std::string> description;
                    ttv::Optional<std::string> profileImageURL;
                    std::string id;
                    ttv::Optional<ttv::Timestamp> createdAt;
                };

                struct InputParams
                {
                    std::string authToken;
                };

                static constexpr const char* kTaskName = "GraphQLTask: GetCurrentUser";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query GetCurrentUser {
                        currentUser {
                            login
                            displayName
                            description
                            profileImageURL(width:150)
                            id
                            createdAt
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::core::graphql::json::GetCurrentUserPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>(MakeKeyPath("currentUser", "login"), payloadType.login),
            make_field<OptionalField>(MakeKeyPath("currentUser", "displayName"), payloadType.displayName),
            make_field<OptionalField>(MakeKeyPath("currentUser", "description"), payloadType.description),
            make_field<OptionalField>(MakeKeyPath("currentUser", "profileImageURL"), payloadType.profileImageURL),
            make_field<RequiredField>(MakeKeyPath("currentUser", "id"), payloadType.id),
            make_field<OptionalField>(MakeKeyPath("currentUser", "createdAt"), payloadType.createdAt)
        );
    }
};


struct ttv::core::graphql::json::GetCurrentUserInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
        );
        (void)inputParams;
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetCurrentUserQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetCurrentUserPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetCurrentUserQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetCurrentUserInputParams>;
};
