/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace core
    {
        namespace graphql
        {
            namespace json
            {
                struct GetStreamGame;
                struct GetStreamVideo;
                struct GetStreamStream;
                struct GetStreamGame1;
                struct GetStreamBroadcast;
                struct GetStreamBroadcastSettings;
                struct GetStreamFollowerConnection;
                struct GetStreamUserRoles;
                struct GetStreamPayloadType;
                struct GetStreamInputParams;
                struct GetStreamLanguage;
            }

            struct GetStreamQueryInfo
            {
                enum class Language
                {
                    AR,
                    ASL,
                    BG,
                    CA,
                    CS,
                    DA,
                    DE,
                    EL,
                    EN,
                    ES,
                    FI,
                    FR,
                    HI,
                    HU,
                    ID,
                    IT,
                    JA,
                    KO,
                    MS,
                    NL,
                    NO,
                    OTHER,
                    PL,
                    PT,
                    RO,
                    RU,
                    SK,
                    SV,
                    TH,
                    TL,
                    TR,
                    UK,
                    VI,
                    ZH,
                    ZH_HK,
                };

                struct Game
                {
                    std::string name;
                };

                struct Video
                {
                    std::string id;
                };

                struct Stream
                {
                    ttv::Optional<std::string> previewImageURL;
                    ttv::Optional<Game> game;
                    ttv::Optional<float> averageFPS;
                    std::string id;
                    ttv::Optional<int32_t> delayLengthSeconds;
                    ttv::Optional<int32_t> viewersCount;
                    ttv::Optional<int32_t> height;
                    ttv::Optional<ttv::Timestamp> createdAt;
                    ttv::Optional<std::string> broadcasterSoftware;
                    ttv::Optional<std::string> type;
                    ttv::Optional<Video> archiveVideo;
                };

                struct Game1
                {
                    std::string name;
                };

                struct Broadcast
                {
                    ttv::Optional<Game1> game;
                    ttv::Optional<std::string> title;
                };

                struct BroadcastSettings
                {
                    Language language;
                    bool isMature;
                };

                struct FollowerConnection
                {
                    ttv::Optional<int32_t> totalCount;
                };

                struct UserRoles
                {
                    ttv::Optional<bool> isAffiliate;
                    ttv::Optional<bool> isPartner;
                };

                struct PayloadType
                {
                    ttv::Optional<Stream> stream;
                    ttv::Optional<std::string> displayName;
                    ttv::Optional<std::string> login;
                    ttv::Optional<Broadcast> lastBroadcast;
                    ttv::Optional<std::string> description;
                    ttv::Optional<BroadcastSettings> broadcastSettings;
                    ttv::Optional<std::string> profileImageURL;
                    ttv::Optional<std::string> profileURL;
                    ttv::Optional<std::string> offlineImageURL;
                    ttv::Optional<std::string> bannerImageURL;
                    std::string id;
                    ttv::Optional<ttv::Timestamp> createdAt;
                    ttv::Optional<ttv::Timestamp> updatedAt;
                    ttv::Optional<FollowerConnection> followers;
                    ttv::Optional<int32_t> profileViewCount;
                    ttv::Optional<UserRoles> roles;
                };

                struct InputParams
                {
                    std::string authToken;
                    ttv::Optional<std::string> userID;
                };

                static constexpr const char* kTaskName = "GraphQLTask: GetStream";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query GetStream($userID:ID) {
                        user(id:$userID) {
                            stream {
                                previewImageURL # stock the template myself
                                game {
                                    name
                                }
                                averageFPS
                                id
                                delayLengthSeconds
                                viewersCount
                                height
                                createdAt
                                broadcasterSoftware #broadcastPlatform
                                type
                                # isPlaylist (infer from `type` above)
                                archiveVideo {
                                    id
                                }
                            }
                            displayName
                            login
                            lastBroadcast {
                                game {
                                    name
                                }
                                title
                            }
                            description
                            broadcastSettings {
                                language
                                isMature
                            }
                            profileImageURL(width:300)
                            profileURL
                            offlineImageURL # videoBannerImageUrl
                            bannerImageURL # profileBannerImageUrl
                            id
                            createdAt
                            updatedAt
                            followers {
                                totalCount
                            }
                            profileViewCount
                            roles {
                                isAffiliate
                                isPartner
                            }
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::core::graphql::json::GetStreamGame
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& game)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("name", game.name)
        );
    }
};


struct ttv::core::graphql::json::GetStreamVideo
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& video)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("id", video.id)
        );
    }
};


struct ttv::core::graphql::json::GetStreamStream
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& stream)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("previewImageURL", stream.previewImageURL),
            make_field<OptionalField>("game", stream.game),
            make_field<OptionalField>("averageFPS", stream.averageFPS),
            make_field<RequiredField>("id", stream.id),
            make_field<OptionalField>("delayLengthSeconds", stream.delayLengthSeconds),
            make_field<OptionalField>("viewersCount", stream.viewersCount),
            make_field<OptionalField>("height", stream.height),
            make_field<OptionalField>("createdAt", stream.createdAt),
            make_field<OptionalField>("broadcasterSoftware", stream.broadcasterSoftware),
            make_field<OptionalField>("type", stream.type),
            make_field<OptionalField>("archiveVideo", stream.archiveVideo)
        );
    }
};


struct ttv::core::graphql::json::GetStreamGame1
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& game1)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("name", game1.name)
        );
    }
};


struct ttv::core::graphql::json::GetStreamBroadcast
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& broadcast)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("game", broadcast.game),
            make_field<OptionalField>("title", broadcast.title)
        );
    }
};


struct ttv::core::graphql::json::GetStreamBroadcastSettings
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& broadcastSettings)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("language", broadcastSettings.language),
            make_field<RequiredField>("isMature", broadcastSettings.isMature)
        );
    }
};


struct ttv::core::graphql::json::GetStreamFollowerConnection
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& followerConnection)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("totalCount", followerConnection.totalCount)
        );
    }
};


struct ttv::core::graphql::json::GetStreamUserRoles
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& userRoles)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("isAffiliate", userRoles.isAffiliate),
            make_field<OptionalField>("isPartner", userRoles.isPartner)
        );
    }
};


struct ttv::core::graphql::json::GetStreamPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>(MakeKeyPath("user", "stream"), payloadType.stream),
            make_field<OptionalField>(MakeKeyPath("user", "displayName"), payloadType.displayName),
            make_field<OptionalField>(MakeKeyPath("user", "login"), payloadType.login),
            make_field<OptionalField>(MakeKeyPath("user", "lastBroadcast"), payloadType.lastBroadcast),
            make_field<OptionalField>(MakeKeyPath("user", "description"), payloadType.description),
            make_field<OptionalField>(MakeKeyPath("user", "broadcastSettings"), payloadType.broadcastSettings),
            make_field<OptionalField>(MakeKeyPath("user", "profileImageURL"), payloadType.profileImageURL),
            make_field<OptionalField>(MakeKeyPath("user", "profileURL"), payloadType.profileURL),
            make_field<OptionalField>(MakeKeyPath("user", "offlineImageURL"), payloadType.offlineImageURL),
            make_field<OptionalField>(MakeKeyPath("user", "bannerImageURL"), payloadType.bannerImageURL),
            make_field<RequiredField>(MakeKeyPath("user", "id"), payloadType.id),
            make_field<OptionalField>(MakeKeyPath("user", "createdAt"), payloadType.createdAt),
            make_field<OptionalField>(MakeKeyPath("user", "updatedAt"), payloadType.updatedAt),
            make_field<OptionalField>(MakeKeyPath("user", "followers"), payloadType.followers),
            make_field<OptionalField>(MakeKeyPath("user", "profileViewCount"), payloadType.profileViewCount),
            make_field<OptionalField>(MakeKeyPath("user", "roles"), payloadType.roles)
        );
    }
};


struct ttv::core::graphql::json::GetStreamInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("userID", inputParams.userID)
        );
    }
};


struct ttv::core::graphql::json::GetStreamLanguage
{
    static auto EnumMap()
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_enum_mapping_case_insensitive("AR", GetStreamQueryInfo::Language::AR),
            make_enum_mapping_case_insensitive("ASL", GetStreamQueryInfo::Language::ASL),
            make_enum_mapping_case_insensitive("BG", GetStreamQueryInfo::Language::BG),
            make_enum_mapping_case_insensitive("CA", GetStreamQueryInfo::Language::CA),
            make_enum_mapping_case_insensitive("CS", GetStreamQueryInfo::Language::CS),
            make_enum_mapping_case_insensitive("DA", GetStreamQueryInfo::Language::DA),
            make_enum_mapping_case_insensitive("DE", GetStreamQueryInfo::Language::DE),
            make_enum_mapping_case_insensitive("EL", GetStreamQueryInfo::Language::EL),
            make_enum_mapping_case_insensitive("EN", GetStreamQueryInfo::Language::EN),
            make_enum_mapping_case_insensitive("ES", GetStreamQueryInfo::Language::ES),
            make_enum_mapping_case_insensitive("FI", GetStreamQueryInfo::Language::FI),
            make_enum_mapping_case_insensitive("FR", GetStreamQueryInfo::Language::FR),
            make_enum_mapping_case_insensitive("HI", GetStreamQueryInfo::Language::HI),
            make_enum_mapping_case_insensitive("HU", GetStreamQueryInfo::Language::HU),
            make_enum_mapping_case_insensitive("ID", GetStreamQueryInfo::Language::ID),
            make_enum_mapping_case_insensitive("IT", GetStreamQueryInfo::Language::IT),
            make_enum_mapping_case_insensitive("JA", GetStreamQueryInfo::Language::JA),
            make_enum_mapping_case_insensitive("KO", GetStreamQueryInfo::Language::KO),
            make_enum_mapping_case_insensitive("MS", GetStreamQueryInfo::Language::MS),
            make_enum_mapping_case_insensitive("NL", GetStreamQueryInfo::Language::NL),
            make_enum_mapping_case_insensitive("NO", GetStreamQueryInfo::Language::NO),
            make_enum_mapping_case_insensitive("OTHER", GetStreamQueryInfo::Language::OTHER),
            make_enum_mapping_case_insensitive("PL", GetStreamQueryInfo::Language::PL),
            make_enum_mapping_case_insensitive("PT", GetStreamQueryInfo::Language::PT),
            make_enum_mapping_case_insensitive("RO", GetStreamQueryInfo::Language::RO),
            make_enum_mapping_case_insensitive("RU", GetStreamQueryInfo::Language::RU),
            make_enum_mapping_case_insensitive("SK", GetStreamQueryInfo::Language::SK),
            make_enum_mapping_case_insensitive("SV", GetStreamQueryInfo::Language::SV),
            make_enum_mapping_case_insensitive("TH", GetStreamQueryInfo::Language::TH),
            make_enum_mapping_case_insensitive("TL", GetStreamQueryInfo::Language::TL),
            make_enum_mapping_case_insensitive("TR", GetStreamQueryInfo::Language::TR),
            make_enum_mapping_case_insensitive("UK", GetStreamQueryInfo::Language::UK),
            make_enum_mapping_case_insensitive("VI", GetStreamQueryInfo::Language::VI),
            make_enum_mapping_case_insensitive("ZH", GetStreamQueryInfo::Language::ZH),
            make_enum_mapping_case_insensitive("ZH_HK", GetStreamQueryInfo::Language::ZH_HK)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::Game>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetStreamGame>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::Video>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetStreamVideo>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::Stream>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetStreamStream>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::Game1>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetStreamGame1>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::Broadcast>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetStreamBroadcast>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::BroadcastSettings>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetStreamBroadcastSettings>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::FollowerConnection>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetStreamFollowerConnection>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::UserRoles>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetStreamUserRoles>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetStreamPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetStreamInputParams>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetStreamQueryInfo::Language>
{
    using Type = EnumSchema<ttv::core::graphql::json::GetStreamLanguage>;
};
