/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace core
    {
        namespace graphql
        {
            namespace json
            {
                struct GetUserByIdPayloadType;
                struct GetUserByIdInputParams;
            }

            struct GetUserByIdQueryInfo
            {
                struct PayloadType
                {
                    ttv::Optional<std::string> login;
                    ttv::Optional<std::string> displayName;
                    ttv::Optional<std::string> description;
                    ttv::Optional<std::string> profileImageURL;
                    std::string id;
                    ttv::Optional<ttv::Timestamp> createdAt;
                };

                struct InputParams
                {
                    std::string authToken;
                    ttv::Optional<std::string> userID;
                };

                static constexpr const char* kTaskName = "GraphQLTask: GetUserById";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query GetUserById($userID:ID) {
                        user(id:$userID) {
                            login
                            displayName
                            description
                            profileImageURL(width:150)
                            id
                            createdAt
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::core::graphql::json::GetUserByIdPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>(MakeKeyPath("user", "login"), payloadType.login),
            make_field<OptionalField>(MakeKeyPath("user", "displayName"), payloadType.displayName),
            make_field<OptionalField>(MakeKeyPath("user", "description"), payloadType.description),
            make_field<OptionalField>(MakeKeyPath("user", "profileImageURL"), payloadType.profileImageURL),
            make_field<RequiredField>(MakeKeyPath("user", "id"), payloadType.id),
            make_field<OptionalField>(MakeKeyPath("user", "createdAt"), payloadType.createdAt)
        );
    }
};


struct ttv::core::graphql::json::GetUserByIdInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("userID", inputParams.userID)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetUserByIdQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetUserByIdPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetUserByIdQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetUserByIdInputParams>;
};
