/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace core
    {
        namespace graphql
        {
            namespace json
            {
                struct GetVodUser;
                struct GetVodPayloadType;
                struct GetVodInputParams;
                struct GetVodVideoStatus;
                struct GetVodBroadcastType;
            }

            struct GetVodQueryInfo
            {
                enum class VideoStatus
                {
                    RECORDING,
                    UNPROCESSED,
                    CREATED,
                    UPLOADING,
                    PENDING_TRANSCODE,
                    FAILED,
                    RECORDED,
                };

                enum class BroadcastType
                {
                    ARCHIVE,
                    HIGHLIGHT,
                    UPLOAD,
                    PREMIERE_UPLOAD,
                    PAST_PREMIERE,
                };

                struct User
                {
                    std::string id;
                };

                struct PayloadType
                {
                    std::string id;
                    ttv::Optional<std::string> title;
                    ttv::Optional<User> owner;
                    ttv::Optional<BroadcastType> broadcastType;
                    ttv::Optional<VideoStatus> status;
                    ttv::Optional<int32_t> lengthSeconds;
                    ttv::Optional<ttv::Timestamp> recordedAt;
                };

                struct InputParams
                {
                    std::string authToken;
                    ttv::Optional<std::string> id;
                };

                static constexpr const char* kTaskName = "GraphQLTask: GetVod";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query GetVod($id:ID) {
                        video(id:$id) {
                            id
                            title
                            owner {
                                id
                            }
                            broadcastType
                            status
                            lengthSeconds
                            recordedAt
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::core::graphql::json::GetVodUser
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& user)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("id", user.id)
        );
    }
};


struct ttv::core::graphql::json::GetVodPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>(MakeKeyPath("video", "id"), payloadType.id),
            make_field<OptionalField>(MakeKeyPath("video", "title"), payloadType.title),
            make_field<OptionalField>(MakeKeyPath("video", "owner"), payloadType.owner),
            make_field<OptionalField>(MakeKeyPath("video", "broadcastType"), payloadType.broadcastType),
            make_field<OptionalField>(MakeKeyPath("video", "status"), payloadType.status),
            make_field<OptionalField>(MakeKeyPath("video", "lengthSeconds"), payloadType.lengthSeconds),
            make_field<OptionalField>(MakeKeyPath("video", "recordedAt"), payloadType.recordedAt)
        );
    }
};


struct ttv::core::graphql::json::GetVodInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("id", inputParams.id)
        );
    }
};


struct ttv::core::graphql::json::GetVodVideoStatus
{
    static auto EnumMap()
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_enum_mapping_case_insensitive("RECORDING", GetVodQueryInfo::VideoStatus::RECORDING),
            make_enum_mapping_case_insensitive("UNPROCESSED", GetVodQueryInfo::VideoStatus::UNPROCESSED),
            make_enum_mapping_case_insensitive("CREATED", GetVodQueryInfo::VideoStatus::CREATED),
            make_enum_mapping_case_insensitive("UPLOADING", GetVodQueryInfo::VideoStatus::UPLOADING),
            make_enum_mapping_case_insensitive("PENDING_TRANSCODE", GetVodQueryInfo::VideoStatus::PENDING_TRANSCODE),
            make_enum_mapping_case_insensitive("FAILED", GetVodQueryInfo::VideoStatus::FAILED),
            make_enum_mapping_case_insensitive("RECORDED", GetVodQueryInfo::VideoStatus::RECORDED)
        );
    }
};


struct ttv::core::graphql::json::GetVodBroadcastType
{
    static auto EnumMap()
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_enum_mapping_case_insensitive("ARCHIVE", GetVodQueryInfo::BroadcastType::ARCHIVE),
            make_enum_mapping_case_insensitive("HIGHLIGHT", GetVodQueryInfo::BroadcastType::HIGHLIGHT),
            make_enum_mapping_case_insensitive("UPLOAD", GetVodQueryInfo::BroadcastType::UPLOAD),
            make_enum_mapping_case_insensitive("PREMIERE_UPLOAD", GetVodQueryInfo::BroadcastType::PREMIERE_UPLOAD),
            make_enum_mapping_case_insensitive("PAST_PREMIERE", GetVodQueryInfo::BroadcastType::PAST_PREMIERE)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetVodQueryInfo::User>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetVodUser>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetVodQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetVodPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetVodQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::core::graphql::json::GetVodInputParams>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetVodQueryInfo::VideoStatus>
{
    using Type = EnumSchema<ttv::core::graphql::json::GetVodVideoStatus>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::core::graphql::GetVodQueryInfo::BroadcastType>
{
    using Type = EnumSchema<ttv::core::graphql::json::GetVodBroadcastType>;
};
