/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2019 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/internal/graphql/utilities/graphqlutilities.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv {
namespace graphql {

template <typename GQLType>
ChannelInfo GQLUserToChannelInfo(const GQLType& user) {
  ChannelInfo result;

  result.name = user.login.ValueOrDefault("");
  result.displayName = user.displayName.ValueOrDefault("");

  if (user.lastBroadcast.HasValue()) {
    const auto& lastBroadcast = user.lastBroadcast.Value();

    if (lastBroadcast.game.HasValue()) {
      result.game = lastBroadcast.game.Value().name;
    }

    result.status = lastBroadcast.title.ValueOrDefault("");
  }

  result.description = user.description.ValueOrDefault("");

  if (user.broadcastSettings.HasValue()) {
    const auto& broadcastSettings = user.broadcastSettings.Value();

    result.mature = broadcastSettings.isMature;

    result.language = GqlLanguageEnumToString(broadcastSettings.language);
    result.broadcasterLanguage = result.language;
  }

  result.logoImageUrl = user.profileImageURL.ValueOrDefault("");
  result.videoBannerImageUrl = user.offlineImageURL.ValueOrDefault("");
  result.profileBannerImageUrl = user.bannerImageURL.ValueOrDefault("");
  result.channelUrl = user.profileURL.ValueOrDefault("");
  result.channelId = static_cast<ttv::ChannelId>(atoi(user.id.c_str()));
  result.createdAtTimestamp = user.createdAt.ValueOrDefault(0);
  result.updatedAtTimestamp = user.updatedAt.ValueOrDefault(0);

  if (user.followers.HasValue()) {
    result.numFollowers = static_cast<uint32_t>(user.followers.Value().totalCount.ValueOrDefault(0));
  }

  result.numViews = static_cast<uint32_t>(user.profileViewCount.ValueOrDefault(0));

  if (user.roles.HasValue()) {
    const auto& roles = user.roles.Value();
    result.partner = roles.isPartner.ValueOrDefault(false);
    result.affiliate = roles.isAffiliate.ValueOrDefault(false);
  }

  return result;
}

}  // namespace graphql
}  // namespace ttv
