/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2019 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/jsonserialization.h"

namespace {
constexpr char kWidthString[] = "{width}";
constexpr char kHeightString[] = "{height}";
}  // namespace

namespace ttv {
namespace graphql {

/**
 * This is a pretty dumb way to do this because it is sensitive to schema changes.
 * Ticket to improve: https://jira.twitch.com/browse/TVAPPS-3439
 */
template <typename GqlLanguageEnum>
std::string GqlLanguageEnumToString(const GqlLanguageEnum& language) {
  std::map<GqlLanguageEnum, std::string> enumToStr;

  enumToStr.emplace(GqlLanguageEnum::AR, "AR");
  enumToStr.emplace(GqlLanguageEnum::ASL, "ASL");
  enumToStr.emplace(GqlLanguageEnum::BG, "BG");
  enumToStr.emplace(GqlLanguageEnum::CA, "CA");
  enumToStr.emplace(GqlLanguageEnum::CS, "CS");
  enumToStr.emplace(GqlLanguageEnum::DA, "DA");
  enumToStr.emplace(GqlLanguageEnum::DE, "DE");
  enumToStr.emplace(GqlLanguageEnum::EL, "EL");
  enumToStr.emplace(GqlLanguageEnum::EN, "EN");
  enumToStr.emplace(GqlLanguageEnum::ES, "ES");
  enumToStr.emplace(GqlLanguageEnum::FI, "FI");
  enumToStr.emplace(GqlLanguageEnum::FR, "FR");
  enumToStr.emplace(GqlLanguageEnum::HI, "HI");
  enumToStr.emplace(GqlLanguageEnum::HU, "HU");
  enumToStr.emplace(GqlLanguageEnum::ID, "ID");
  enumToStr.emplace(GqlLanguageEnum::IT, "IT");
  enumToStr.emplace(GqlLanguageEnum::JA, "JA");
  enumToStr.emplace(GqlLanguageEnum::KO, "KO");
  enumToStr.emplace(GqlLanguageEnum::MS, "MS");
  enumToStr.emplace(GqlLanguageEnum::NL, "NL");
  enumToStr.emplace(GqlLanguageEnum::NO, "NO");
  enumToStr.emplace(GqlLanguageEnum::OTHER, "OTHER");
  enumToStr.emplace(GqlLanguageEnum::PL, "PL");
  enumToStr.emplace(GqlLanguageEnum::PT, "PT");
  enumToStr.emplace(GqlLanguageEnum::RO, "RO");
  enumToStr.emplace(GqlLanguageEnum::RU, "RU");
  enumToStr.emplace(GqlLanguageEnum::SK, "SK");
  enumToStr.emplace(GqlLanguageEnum::SV, "SV");
  enumToStr.emplace(GqlLanguageEnum::TH, "TH");
  enumToStr.emplace(GqlLanguageEnum::TL, "TL");
  enumToStr.emplace(GqlLanguageEnum::TR, "TR");
  enumToStr.emplace(GqlLanguageEnum::UK, "UK");
  enumToStr.emplace(GqlLanguageEnum::VI, "VI");
  enumToStr.emplace(GqlLanguageEnum::ZH, "ZH");
  enumToStr.emplace(GqlLanguageEnum::ZH_HK, "ZH_HK");

  return enumToStr[language];
}

ChannelId GQLUserIdToChannelId(const std::string& gqlUserId);

}  // namespace graphql
}  // namespace ttv
