/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/errortypes.h"
#include "twitchsdk/core/types/memorytypes.h"

namespace ttv {
/**
 * Performs an aligned allocation using the registered allocator.
 */
void* AlignedAlloc(size_t size, size_t alignment);
/**
 * Fres an allocation previously allocated via AlignedAlloc().
 */
void AlignedFree(void* p);
/**
 * This will set custom memory allocation callbacks to be used by all Twitch SDK code.
 */
TTV_ErrorCode SetMemoryAllocationCallbacks(TTV_AllocCallback allocCallback, TTV_FreeCallback freeCallback);
}  // namespace ttv
