/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/pubsub/pubsubcomponent.h"

#include <memory>

namespace ttv {
class IChannelListener;
class ProfileImageStatus;
}  // namespace ttv

/**
 * Handle profile image upload and listeners for successful upload
 */
class ttv::ProfileImageStatus : public ttv::PubSubComponent<IChannelListener> {
 public:
  using DisposerFunc = std::function<void()>;
  using UploadProfileImageCallback = std::function<void(TTV_ErrorCode ec, const std::vector<ProfileImage>& images)>;

 public:
  ProfileImageStatus(const std::shared_ptr<User>& user, ChannelId userId);

  TTV_ErrorCode UploadProfileImage(
    const char* imageBuffer, size_t imageSize, const UploadProfileImageCallback& callback);

  virtual void Update() override;

  static std::string GetComponentName() { return "ttv::ProfileImageStatus"; }
  virtual std::string GetLoggerName() const override;

  void OnTopicSubscribeStateChanged(
    const std::string& /*topic*/, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode /*ec*/) override;
  void OnTopicMessageReceived(const std::string& topic, const json::Value& msg) override;

 private:
  virtual bool CheckShutdown() override;

  void FireListenerAndCallback(const std::string& uploadId, const std::vector<ProfileImage>& images, TTV_ErrorCode ec);
  UploadProfileImageCallback mCallback;

  WaitForEventWithTimeout mUploadTimeout;

  std::string mImage;
  std::string mUploadId;
  std::string mPubSubTopic;
  UserId mUserId;
  bool mUploadInProgress;
};
