/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

template <typename _ctorRet_t>
struct RaiiWrapper {
  RaiiWrapper(std::function<_ctorRet_t()> createCall, std::function<void()> destroyCall)
      : mCtorRet(createCall()), mDestroyCall(destroyCall) {}

  ~RaiiWrapper() { mDestroyCall(); }

  void Release() { mDestroyCall = nullptr; }

  std::function<void()> mDestroyCall;
  _ctorRet_t mCtorRet;

 private:
  RaiiWrapper(const RaiiWrapper& rhs);
  RaiiWrapper& operator=(const RaiiWrapper& rhs);
};
