/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"

#include <unordered_map>

#include <memory>
#include <string>
#include <vector>

namespace ttv {
class SettingRepository;
class IMutex;
}  // namespace ttv

class ttv::SettingRepository {
 public:
  SettingRepository();

  void SetSetting(const std::string& key, const std::string& value);
  bool GetSetting(const std::string& key, std::string& value);
  bool RemoveSetting(const std::string& key);

 protected:
  std::unordered_map<std::string, std::string> mSettings;
  std::unique_ptr<IMutex> mMutex;
};
