/*
    sha1.hpp - header of

    ============
    SHA-1 in C++
    ============

    100% Public Domain.

    Original C Code
        -- Steve Reid <steve@edmweb.com>
    Small changes to fit into bglibs
        -- Bruce Guenter <bruce@untroubled.org>
    Translation to simpler C++ Code
        -- Volker Grabsch <vog@notjusthosting.com>
    Safety fixes
        -- Eugene Hopkinson <slowriot at voxelstorm dot com>
*/

#pragma once

#include <cstdint>
#include <iostream>
#include <string>

namespace ttv {
class SHA1;
}

class ttv::SHA1 {
 public:
  SHA1();
  void Update(const std::string &s);
  void Update(std::istream &is);
  std::string Final();

  static uint32_t HashAsUInt32(const std::string &hash);

 private:
  uint32_t digest[5];
  std::string buffer;
  uint64_t transforms;
};
