/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/user/user.h"

namespace ttv {
class GetChannelTask;
struct ChannelInfo;
}  // namespace ttv

class ttv::GetChannelTask : public ttv::HttpTask {
 public:
  struct Result {
    ChannelInfo channelInfo;
  };

  using Callback = std::function<void(GetChannelTask* source, TTV_ErrorCode ec, std::shared_ptr<Result> result)>;

 public:
  GetChannelTask(ChannelId channelId, Callback callback);

  virtual const char* GetTaskName() const override { return "GetChannelTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  ChannelId mChannelId;
};
