/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/types/coretypes.h"

namespace ttv {
class GetStreamTask;
}

class ttv::GetStreamTask : public ttv::HttpTask {
 public:
  struct Result {
    std::unique_ptr<StreamInfo> streamInfo;
  };

  using Callback = std::function<void(GetStreamTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  GetStreamTask(ChannelId channelId, const std::string& oauthToken, Callback callback);
  GetStreamTask(const std::string& channelName, const std::string& oauthToken, Callback callback);

  virtual void OnComplete() override;
  virtual const char* GetTaskName() const override { return "GetStreamTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint status, const std::vector<char>& response) override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  std::string mChannelName;
  ChannelId mChannelId;
};
