
#pragma once

#include "twitchsdk/core/task/httptask.h"

namespace ttv {
class GetVodTask;
}

class ttv::GetVodTask : public ttv::HttpTask {
 public:
  struct Result {
    std::string vodId;            // The unique id of the VOD.
    std::string title;            // The user-defined title of the VOD.
    ChannelId channelId;          // The id of the channel to which the VOD belongs
    VodType vodType;              // The type of VOD.
    VodStatus status;             // The current status of the VOD.
    uint32_t durationSeconds;     // The length of the VOD in seconds.
    Timestamp recordedAtSeconds;  // The unix timestamp in seconds.
  };

  using Callback = std::function<void(GetVodTask* source, TTV_ErrorCode ec, std::shared_ptr<Result> result)>;

 public:
  GetVodTask(const std::string& vodId, Callback callback);

 protected:
  virtual const char* GetTaskName() const override { return "GetVodTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  std::string mVodId;
};
