/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/httprequest.h"
#include "twitchsdk/core/task/task.h"

namespace ttv {
class HttpTask;
}

class ttv::HttpTask : public ttv::Task {
 public:
  struct HttpRequestInfo {
    HttpRequestInfo();

    std::string url;
    std::vector<HttpParam> requestHeaders;
    std::string requestBody;
    HttpRequestType httpReqType;
    uint32_t timeOutInSecs;
  };

 public:
  HttpTask();
  HttpTask(const std::string& authToken);
  HttpTask(TaskCallback callback, void* userData, const char* authToken);

  virtual void Run() override;
  virtual void OnComplete() override;

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) = 0;
  virtual bool HeadersCallback(uint statusCode, const std::map<std::string, std::string>& headers);
  virtual void ResponseCallback(uint statusCode, const std::vector<char>& response);
  virtual bool ProcessHeaders(uint statusCode, const std::map<std::string, std::string>& headers);
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response);

  static bool Is2XX(uint32_t statusCode) { return statusCode >= 200 && statusCode <= 299; }
  static bool Is3XX(uint32_t statusCode) { return statusCode >= 300 && statusCode <= 399; }
  static bool Is4XX(uint32_t statusCode) { return statusCode >= 400 && statusCode <= 499; }
  static bool Is5XX(uint32_t statusCode) { return statusCode >= 500 && statusCode <= 599; }

  virtual void PopulateErrorDetails(TTV_ErrorCode ec, uint statusCode, const std::string& message);

 protected:
  HttpRequestInfo mHttpRequestInfo;
  ErrorDetails mTaskStatus;

 private:
  std::string mAuthToken;
};
