/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/task.h"

#include <algorithm>

namespace ttv {
class LambdaTask;
}

/**
 * A simple task which simply runs the given lambda on the worker thread.
 */
class ttv::LambdaTask : public ttv::Task {
 public:
  using JobCallback = std::function<TTV_ErrorCode()>;
  using CompleteCallback = std::function<void(LambdaTask* source, TTV_ErrorCode ec)>;

 public:
  LambdaTask(JobCallback lambda, CompleteCallback callback);
  LambdaTask(const std::string& name, JobCallback lambda, CompleteCallback callback);

  virtual void Run() override;
  virtual void OnComplete() override;
  virtual const char* GetTaskName() const override { return mName.c_str(); }

 private:
  std::string mName;
  JobCallback mLambda;
  CompleteCallback mCallback;
  TTV_ErrorCode mTaskStatus;
};
