/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"

namespace ttv {
class SimpleJsonHttpTask;
}

class ttv::SimpleJsonHttpTask : public ttv::HttpTask {
 public:
  struct Result {
    json::Value json;
  };

  using Callback = std::function<void(SimpleJsonHttpTask* source, TTV_ErrorCode ec, std::shared_ptr<Result> result)>;

 public:
  SimpleJsonHttpTask(const std::string& url, HttpRequestType method, const std::string& oauthToken, Callback callback);

  void SetNumRetries(uint numRetries) { mNumRetries = numRetries; }

  virtual void OnComplete() override;
  virtual const char* GetTaskName() const override { return "SimpleJsonHttpTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  std::shared_ptr<Result> mResult;
  std::string mUrl;
  HttpRequestType mMethod;
  uint mNumRetries;
  Callback mCallback;
};
