/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/tasktypes.h"

#include <atomic>

namespace ttv {
class Task;
}

class ttv::Task {
 public:
  using TaskCallback = TTV_TaskCallback;

 public:
  Task() : mTaskCallback(nullptr), mUserData(nullptr) { mAborted = false; }

  Task(TaskCallback callback, void* userData) : mTaskCallback(callback), mUserData(userData) { mAborted = false; }

  virtual ~Task() = default;

  virtual void Run() = 0;
  virtual void Abort();
  virtual void OnComplete() = 0;
  virtual const char* GetTaskName() const = 0;

 protected:
  TaskCallback mTaskCallback;
  void* mUserData;
  std::atomic_bool mAborted;
};
