/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/concurrentqueue.h"
#include "twitchsdk/core/eventscheduler.h"
#include "twitchsdk/core/task/task.h"

#include <atomic>

namespace ttv {
class TaskRunner;
}

class ttv::TaskRunner {
 public:
  TaskRunner();
  TaskRunner(const std::string& name);
  ~TaskRunner();

 public:
  bool AddTask(std::shared_ptr<Task> task);
  void PollTasks();
  TTV_ErrorCode Shutdown();
  void CompleteShutdown();
  bool IsShutdown() const { return mState == TaskRunnerState::ShutDown; }

 private:
  void Initialize();

 private:
  enum class TaskRunnerState { Running, ShuttingDown, ShutDown };

  ConcurrentQueue<std::shared_ptr<Task>> mDoneTaskQ;

  std::shared_ptr<IEventScheduler> mBackgroundEventScheduler;
  std::string mName;
  std::atomic<TaskRunnerState> mState;
};
