/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/task/httptask.h"

namespace ttv {
class UploadProfileImageTask;
}

class ttv::UploadProfileImageTask : public ttv::HttpTask {
 public:
  struct Result {};

  using Callback =
    std::function<void(UploadProfileImageTask* source, TTV_ErrorCode ec, std::shared_ptr<Result> result)>;

 public:
  UploadProfileImageTask(const std::string& uploadUrl, const std::string& image, Callback callback);

 protected:
  virtual const char* GetTaskName() const override { return "UploadProfileImageTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  std::string mUploadUrl;
  std::string mImage;
};
