/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/task/httptask.h"

namespace ttv {
class ValidateOAuthTask;
}

class ttv::ValidateOAuthTask : public ttv::HttpTask {
 public:
  struct Result {
    std::string userName;
    std::vector<std::string> scopes;
    bool valid;
  };

  using Callback = std::function<void(ValidateOAuthTask* source, TTV_ErrorCode ec, std::shared_ptr<Result> result)>;

 public:
  ValidateOAuthTask(const std::string& oauthToken, Callback callback);

  virtual const char* GetTaskName() const override { return "ValidateOAuthTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  std::string mOAuthToken;
  Callback mCallback;
  std::shared_ptr<Result> mResult;
};
