/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/eventscheduler.h"

namespace ttv {
class ThreadedEventSchedulerFactory;
}

/**
 * An implemention of IBackgroundEventSchedulerFactory that uses the ThreadedEventScheduler.
 *
 * Using the build setting TTV_USE_STD_BACKGROUND_EVENT_SCHEDULER will use this factory.
 * Platforms should implement their own platform-specific main/background event schedulers and factories.
 */
class ttv::ThreadedEventSchedulerFactory : public IBackgroundEventSchedulerFactory {
 public:
  virtual TTV_ErrorCode CreateBackgroundEventScheduler(std::shared_ptr<IEventScheduler>& result) override;
  virtual TTV_ErrorCode CreateBackgroundEventScheduler(
    const std::string& name, std::shared_ptr<IEventScheduler>& result) override;
};
