/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"

namespace ttv {
class IThreadSync;
class IThreadSyncFactory;

void SetThreadSyncFactory(std::shared_ptr<IThreadSyncFactory> factory);

TTV_ErrorCode CreateThreadSync(std::shared_ptr<IThreadSync>& result, const std::string& name);
}  // namespace ttv

class ttv::IThreadSync {
 public:
  virtual ~IThreadSync();

  virtual TTV_ErrorCode Suspend() = 0;
  virtual TTV_ErrorCode SuspendFor(uint duration) = 0;
  virtual TTV_ErrorCode Signal() = 0;
};

class ttv::IThreadSyncFactory {
 public:
  virtual ~IThreadSyncFactory();

  virtual TTV_ErrorCode CreateThreadSync(std::shared_ptr<IThreadSync>& result, const std::string& name) = 0;
};
