/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/coretypes.h"

#include <string>
#include <vector>

namespace ttv {
struct DashboardActivityHeader {
  DashboardActivityHeader() : timestamp(0) {}

  std::string id;
  Timestamp timestamp;
};

struct DashboardActivityUser {
  std::string displayName;
  std::string login;
  std::string userId;
};

struct DashboardActivityFragment {
  std::string emoticonId;
  std::string emoticonSetId;
  std::string text;
};

struct DashboardActivityBitsUsage {
  DashboardActivityBitsUsage() : amount(0), anonymous(false) {}

  DashboardActivityHeader header;
  DashboardActivityUser user;
  uint64_t amount;
  bool anonymous;
};

struct DashboardActivityFollow {
  DashboardActivityHeader header;
  DashboardActivityUser follower;
};

struct DashboardActivityHost {
  DashboardActivityHost() : viewerCount(0) {}
  DashboardActivityHeader header;
  DashboardActivityUser host;
  int64_t viewerCount;
};

struct DashboardActivityRaiding {
  DashboardActivityRaiding() : viewerCount(0) {}

  DashboardActivityHeader header;
  DashboardActivityUser raider;
  int64_t viewerCount;
};

struct DashboardActivitySubscription {
  DashboardActivityHeader header;
  DashboardActivityUser subscriber;
  std::string tier;
};

struct DashboardActivityResubscriptionSharing {
  DashboardActivityResubscriptionSharing() : cumulativeTenureMonths(0) {}

  DashboardActivityHeader header;
  DashboardActivityUser subscriber;
  std::string tier;
  int64_t cumulativeTenureMonths;
  std::vector<DashboardActivityFragment> customMessageFragments;
  std::string customMessage;
};

struct DashboardActivitySubscriptionGiftingCommunity {
  DashboardActivitySubscriptionGiftingCommunity() : anonymous(false), quantity(0) {}

  DashboardActivityHeader header;
  DashboardActivityUser gifter;
  bool anonymous;
  int64_t quantity;
  std::string tier;
};

struct DashboardActivitySubscriptionGiftingIndividual {
  DashboardActivitySubscriptionGiftingIndividual() : anonymous(false) {}

  DashboardActivityHeader header;
  DashboardActivityUser gifter;
  DashboardActivityUser recipient;
  bool anonymous;
  std::string tier;
};
}  // namespace ttv
