/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

namespace ttv {
/**
 * Signature for memory allocating.
 */
using TTV_AllocCallback = void* (*)(size_t size, size_t alignment);
/**
 * Signature for freeing a memory allocation.
 */
using TTV_FreeCallback = void (*)(void* ptr);
}  // namespace ttv

// Default aligned malloc/free if the client doesn't provide them
// These are just wrappers around the functions provided by the CRT
//
void* DefaultAlignedMalloc(size_t size, size_t alignment);
void DefaultAlignedFree(void* p);
