/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/coretypes.h"

namespace ttv {
class OAuthToken;
}

class ttv::OAuthToken {
 public:
  OAuthToken(const std::string& token);

  std::string GetToken() const { return mToken; }

  const std::vector<std::string>& GetScopes() const { return mScopes; }
  void SetScopes(const std::vector<std::string>& scopes) { mScopes = scopes; }

  bool GetValid() const { return mValid; }
  void SetValid(bool valid) { mValid = valid; }

 private:
  std::string mToken;
  std::vector<std::string> mScopes;
  bool mValid;
};
