/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"

#include <memory>

namespace ttv {
class User;
class IUserListener;
class OAuthToken;
}  // namespace ttv

class ttv::IUserListener {
 public:
  virtual ~IUserListener() = default;

  /**
   * The async response for a call to set or update the user's OAuth token.
   */
  virtual void OnUserLogInComplete(User* source, TTV_ErrorCode ec) = 0;
  /**
   * The async response for a request to log the user out.
   */
  virtual void OnUserLogOutComplete(User* source, TTV_ErrorCode ec) = 0;
  /**
   * The async response for a fetch of the user info.
   */
  virtual void OnUserInfoFetchComplete(User* source, TTV_ErrorCode ec) = 0;
  /**
   * The async event for when a user's OAuth token has been determined to be insufficient for accessing a resource.
   */
  virtual void OnUserAuthenticationIssue(
    User* source, std::shared_ptr<const OAuthToken> oauthToken, TTV_ErrorCode ec) = 0;
};
