/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"

namespace ttv {
/**
 * Sets the version string for the sdk. This should be called be the glue code generated by the generator scripts.
 */
TTV_ErrorCode SetVersionString(const std::string& clientId);
/**
 * Retrieves the version string for the sdk.
 */
TTV_ErrorCode GetVersionString(std::string& clientId);
}  // namespace ttv
