/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/assertion.h"

namespace {
ttv::assertion::AssertHandler gAssertHandler = nullptr;
}

namespace ttv {
namespace assertion {
/**
 * Forward declaration of the platform-specific asssert.  This will be defined in a custom .cpp
 * file on each platform.
 */
void PlatformAssert(const char* expr, const char* component, const char* message, const char* file, int line);
}  // namespace assertion
}  // namespace ttv

ttv::assertion::AssertHandler ttv::assertion::SetAssertHandler(ttv::assertion::AssertHandler assertHandler) {
  std::swap(assertHandler, gAssertHandler);

  return assertHandler;
}

bool ttv::assertion::AssertFailed(
  const char* expression, const char* component, const char* message, const char* file, int line) {
  trace::Message(component, MessageLevel::Error, "ASSERT[%s:%i] \"%s\" %s", file, line, expression, message);

#if !defined(NDEBUG)
  if (gAssertHandler == nullptr || !gAssertHandler(expression, component, message, file, line)) {
    // Call the platform-specific assert function
    PlatformAssert(expression, component, message, file, line);
  }
#endif
  return false;
}

void ttv::assertion::details::Assert(
  bool assertion, const char* expr, const char* component, const char* message, const char* file, int line) {
  if (!assertion) {
    AssertFailed(expr, component, message, file, line);
  }
}

void ttv::assertion::details::Assert(bool assertion, const char* expr, const char* file, int line) {
  Assert(assertion, expr, "unknown", "", file, line);
}
