/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/eventscheduler.h"

namespace {
using namespace ttv;

std::shared_ptr<IMainEventSchedulerFactory> gMainEventSchedulerFactory;
std::shared_ptr<IBackgroundEventSchedulerFactory> gBackgroundEventSchedulerFactory;
}  // namespace

ttv::IMainEventSchedulerFactory::~IMainEventSchedulerFactory() {}

ttv::IBackgroundEventSchedulerFactory::~IBackgroundEventSchedulerFactory() {}

void ttv::SetMainEventSchedulerFactory(const std::shared_ptr<IMainEventSchedulerFactory>& factory) {
  gMainEventSchedulerFactory = factory;
}

void ttv::SetBackgroundEventSchedulerFactory(const std::shared_ptr<IBackgroundEventSchedulerFactory>& factory) {
  gBackgroundEventSchedulerFactory = factory;
}

TTV_ErrorCode ttv::CreateMainEventScheduler(std::shared_ptr<IEventScheduler>& result) {
  if (gMainEventSchedulerFactory == nullptr) {
    return TTV_EC_NOT_INITIALIZED;
  }

  return gMainEventSchedulerFactory->CreateMainEventScheduler(result);
}

TTV_ErrorCode ttv::CreateMainEventScheduler(const std::string& name, std::shared_ptr<IEventScheduler>& result) {
  if (gMainEventSchedulerFactory == nullptr) {
    return TTV_EC_NOT_INITIALIZED;
  }

  return gMainEventSchedulerFactory->CreateMainEventScheduler(name, result);
}

TTV_ErrorCode ttv::CreateBackgroundEventScheduler(std::shared_ptr<IEventScheduler>& result) {
  TTV_ASSERT(gBackgroundEventSchedulerFactory != nullptr);
  if (gBackgroundEventSchedulerFactory == nullptr) {
    return TTV_EC_NOT_INITIALIZED;
  }

  return gBackgroundEventSchedulerFactory->CreateBackgroundEventScheduler(result);
}

TTV_ErrorCode ttv::CreateBackgroundEventScheduler(const std::string& name, std::shared_ptr<IEventScheduler>& result) {
  TTV_ASSERT(gBackgroundEventSchedulerFactory != nullptr);
  if (gBackgroundEventSchedulerFactory == nullptr) {
    return TTV_EC_NOT_INITIALIZED;
  }

  return gBackgroundEventSchedulerFactory->CreateBackgroundEventScheduler(name, result);
}
