/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/genericsubscriberstatus.h"

namespace {
const char* kLoggerName = "GenericSubscriberStatus";
}  // namespace

ttv::GenericSubscriberStatus::GenericSubscriberStatus(
  const std::shared_ptr<User>& user, const std::string& subscriberTopic)
    : PubSubComponent(user), mPubSubTopic(subscriberTopic) {
  AddTopic(mPubSubTopic);
}

std::string ttv::GenericSubscriberStatus::GetLoggerName() const {
  return kLoggerName;
}

TTV_ErrorCode ttv::GenericSubscriberStatus::Dispose() {
  if (mDisposerFunc != nullptr) {
    mDisposerFunc();

    mDisposerFunc = nullptr;
  }

  return TTV_EC_SUCCESS;
}

void ttv::GenericSubscriberStatus::OnTopicSubscribeStateChanged(
  const std::string& /*topic*/, PubSubClient::SubscribeState::Enum state, TTV_ErrorCode /*ec*/) {
  ttv::trace::Message(GetLoggerName().c_str(), MessageLevel::Debug,
    "GenericSubscriberStatusListener SubscribeStateChanged: %s", PubSubClient::SubscribeState::ToString(state).c_str());
}

void ttv::GenericSubscriberStatus::OnTopicMessageReceived(const std::string& topic, const ttv::json::Value& jRoot) {
  if (mListener == nullptr) {
    Log(MessageLevel::Error, "Listener not initialized");
    return;
  }

  if (topic != mPubSubTopic) {
    return;
  }

  // malformed json will contain the original string, do not run through fast writer because it will "stringify" it,
  // adding extra "\" for special chars such as \" =? \\\"
  if (jRoot.isString()) {
    mListener->EventTopicData(jRoot.asCString());
  } else {
    json::FastWriter writer;
    mListener->EventTopicData(writer.write(jRoot));
  }
}
