/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2019 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/internal/graphql/utilities/graphqlutilities.h"

namespace {
constexpr char kLogTag[] = "GraphQLUtilities";
}  // namespace

ttv::ChannelId ttv::graphql::GQLUserIdToChannelId(const std::string& gqlUserId) {
  auto id = std::strtoul(gqlUserId.c_str(), nullptr, 10);
  TTV_ASSERT(id != 0, kLogTag, "0 is not a valid ChannelId");
  return static_cast<ttv::ChannelId>(id);
}
